<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer StructType
 * @subpackage Structs
 */
class Customer extends AbstractStructBase
{
    /**
     * The InvoiceAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\InvoiceAddress
     */
    public $InvoiceAddress;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Email;
    /**
     * The DeliveryAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $DeliveryAddress;
    /**
     * Constructor method for Customer
     * @uses Customer::setInvoiceAddress()
     * @uses Customer::setEmail()
     * @uses Customer::setDeliveryAddress()
     * @param \StructType\InvoiceAddress $invoiceAddress
     * @param string $email
     * @param \StructType\Address $deliveryAddress
     */
    public function __construct(\StructType\InvoiceAddress $invoiceAddress = null, $email = null, \StructType\Address $deliveryAddress = null)
    {
        $this
            ->setInvoiceAddress($invoiceAddress)
            ->setEmail($email)
            ->setDeliveryAddress($deliveryAddress);
    }
    /**
     * Get InvoiceAddress value
     * @return \StructType\InvoiceAddress
     */
    public function getInvoiceAddress()
    {
        return $this->InvoiceAddress;
    }
    /**
     * Set InvoiceAddress value
     * @param \StructType\InvoiceAddress $invoiceAddress
     * @return \StructType\Customer
     */
    public function setInvoiceAddress(\StructType\InvoiceAddress $invoiceAddress = null)
    {
        $this->InvoiceAddress = $invoiceAddress;
        return $this;
    }
    /**
     * Get Email value
     * @return string
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Customer
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return \StructType\Address|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param \StructType\Address $deliveryAddress
     * @return \StructType\Customer
     */
    public function setDeliveryAddress(\StructType\Address $deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Customer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
