<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateOrderResponse StructType
 * @subpackage Structs
 */
class CreateOrderResponse extends AbstractStructBase
{
    /**
     * The OrderResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\OrderResponse[]
     */
    public $OrderResponse;
    /**
     * Constructor method for CreateOrderResponse
     * @uses CreateOrderResponse::setOrderResponse()
     * @param \StructType\OrderResponse[] $orderResponse
     */
    public function __construct(array $orderResponse = array())
    {
        $this
            ->setOrderResponse($orderResponse);
    }
    /**
     * Get OrderResponse value
     * @return \StructType\OrderResponse[]
     */
    public function getOrderResponse()
    {
        return $this->OrderResponse;
    }
    /**
     * Set OrderResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderResponse[] $orderResponse
     * @return \StructType\CreateOrderResponse
     */
    public function setOrderResponse(array $orderResponse = array())
    {
        foreach ($orderResponse as $createOrderResponseOrderResponseItem) {
            // validation for constraint: itemType
            if (!$createOrderResponseOrderResponseItem instanceof \StructType\OrderResponse) {
                throw new \InvalidArgumentException(sprintf('The OrderResponse property can only contain items of \StructType\OrderResponse, "%s" given', is_object($createOrderResponseOrderResponseItem) ? get_class($createOrderResponseOrderResponseItem) : gettype($createOrderResponseOrderResponseItem)), __LINE__);
            }
        }
        $this->OrderResponse = $orderResponse;
        return $this;
    }
    /**
     * Add item to OrderResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderResponse $item
     * @return \StructType\CreateOrderResponse
     */
    public function addToOrderResponse(\StructType\OrderResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderResponse) {
            throw new \InvalidArgumentException(sprintf('The OrderResponse property can only contain items of \StructType\OrderResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OrderResponse[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateOrderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
