<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateOrderRequest StructType
 * @subpackage Structs
 */
class CreateOrderRequest extends AbstractStructBase
{
    /**
     * The ThirdPartyId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ThirdPartyId;
    /**
     * The Order
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Order[]
     */
    public $Order;
    /**
     * Constructor method for CreateOrderRequest
     * @uses CreateOrderRequest::setThirdPartyId()
     * @uses CreateOrderRequest::setOrder()
     * @param string $thirdPartyId
     * @param \StructType\Order[] $order
     */
    public function __construct($thirdPartyId = null, array $order = array())
    {
        $this
            ->setThirdPartyId($thirdPartyId)
            ->setOrder($order);
    }
    /**
     * Get ThirdPartyId value
     * @return string
     */
    public function getThirdPartyId()
    {
        return $this->ThirdPartyId;
    }
    /**
     * Set ThirdPartyId value
     * @param string $thirdPartyId
     * @return \StructType\CreateOrderRequest
     */
    public function setThirdPartyId($thirdPartyId = null)
    {
        // validation for constraint: string
        if (!is_null($thirdPartyId) && !is_string($thirdPartyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($thirdPartyId)), __LINE__);
        }
        $this->ThirdPartyId = $thirdPartyId;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\Order[]
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @throws \InvalidArgumentException
     * @param \StructType\Order[] $order
     * @return \StructType\CreateOrderRequest
     */
    public function setOrder(array $order = array())
    {
        foreach ($order as $createOrderRequestOrderItem) {
            // validation for constraint: itemType
            if (!$createOrderRequestOrderItem instanceof \StructType\Order) {
                throw new \InvalidArgumentException(sprintf('The Order property can only contain items of \StructType\Order, "%s" given', is_object($createOrderRequestOrderItem) ? get_class($createOrderRequestOrderItem) : gettype($createOrderRequestOrderItem)), __LINE__);
            }
        }
        $this->Order = $order;
        return $this;
    }
    /**
     * Add item to Order value
     * @throws \InvalidArgumentException
     * @param \StructType\Order $item
     * @return \StructType\CreateOrderRequest
     */
    public function addToOrder(\StructType\Order $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Order) {
            throw new \InvalidArgumentException(sprintf('The Order property can only contain items of \StructType\Order, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Order[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateOrderRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
