<?php

namespace EnumType;

/**
 * This class stands for PaymentMethod EnumType
 * @subpackage Enumerations
 */
class PaymentMethod
{
    /**
     * Constant for value 'BANKTRANSACTION'
     * @return string 'BANKTRANSACTION'
     */
    const VALUE_BANKTRANSACTION = 'BANKTRANSACTION';
    /**
     * Constant for value 'PAYINSLIP'
     * @return string 'PAYINSLIP'
     */
    const VALUE_PAYINSLIP = 'PAYINSLIP';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BANKTRANSACTION
     * @uses self::VALUE_PAYINSLIP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BANKTRANSACTION,
            self::VALUE_PAYINSLIP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
