<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderItem StructType
 * @subpackage Structs
 */
class OrderItem extends AbstractStructBase
{
    /**
     * The AvinoItemId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AvinoItemId;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Price;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Quantity;
    /**
     * The VatRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $VatRate;
    /**
     * Constructor method for OrderItem
     * @uses OrderItem::setAvinoItemId()
     * @uses OrderItem::setName()
     * @uses OrderItem::setPrice()
     * @uses OrderItem::setQuantity()
     * @uses OrderItem::setVatRate()
     * @param int $avinoItemId
     * @param string $name
     * @param float $price
     * @param int $quantity
     * @param float $vatRate
     */
    public function __construct($avinoItemId = null, $name = null, $price = null, $quantity = null, $vatRate = null)
    {
        $this
            ->setAvinoItemId($avinoItemId)
            ->setName($name)
            ->setPrice($price)
            ->setQuantity($quantity)
            ->setVatRate($vatRate);
    }
    /**
     * Get AvinoItemId value
     * @return int
     */
    public function getAvinoItemId()
    {
        return $this->AvinoItemId;
    }
    /**
     * Set AvinoItemId value
     * @param int $avinoItemId
     * @return \StructType\OrderItem
     */
    public function setAvinoItemId($avinoItemId = null)
    {
        // validation for constraint: int
        if (!is_null($avinoItemId) && !is_numeric($avinoItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($avinoItemId)), __LINE__);
        }
        $this->AvinoItemId = $avinoItemId;
        return $this;
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\OrderItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Price value
     * @return float
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\OrderItem
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\OrderItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get VatRate value
     * @return float|null
     */
    public function getVatRate()
    {
        return $this->VatRate;
    }
    /**
     * Set VatRate value
     * @param float $vatRate
     * @return \StructType\OrderItem
     */
    public function setVatRate($vatRate = null)
    {
        $this->VatRate = $vatRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
