<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Order StructType
 * @subpackage Structs
 */
class Order extends AbstractStructBase
{
    /**
     * The OrderNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderNumber;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Customer
     */
    public $Customer;
    /**
     * The SellerOrder
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\SellerOrder[]
     */
    public $SellerOrder;
    /**
     * The TotalGrossAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalGrossAmount;
    /**
     * The TotalShippingCosts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalShippingCosts;
    /**
     * Constructor method for Order
     * @uses Order::setOrderNumber()
     * @uses Order::setCustomer()
     * @uses Order::setSellerOrder()
     * @uses Order::setTotalGrossAmount()
     * @uses Order::setTotalShippingCosts()
     * @param string $orderNumber
     * @param \StructType\Customer $customer
     * @param \StructType\SellerOrder[] $sellerOrder
     * @param float $totalGrossAmount
     * @param float $totalShippingCosts
     */
    public function __construct($orderNumber = null, \StructType\Customer $customer = null, array $sellerOrder = array(), $totalGrossAmount = null, $totalShippingCosts = null)
    {
        $this
            ->setOrderNumber($orderNumber)
            ->setCustomer($customer)
            ->setSellerOrder($sellerOrder)
            ->setTotalGrossAmount($totalGrossAmount)
            ->setTotalShippingCosts($totalShippingCosts);
    }
    /**
     * Get OrderNumber value
     * @return string
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param string $orderNumber
     * @return \StructType\Order
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get Customer value
     * @return \StructType\Customer
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\Customer $customer
     * @return \StructType\Order
     */
    public function setCustomer(\StructType\Customer $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get SellerOrder value
     * @return \StructType\SellerOrder[]
     */
    public function getSellerOrder()
    {
        return $this->SellerOrder;
    }
    /**
     * Set SellerOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\SellerOrder[] $sellerOrder
     * @return \StructType\Order
     */
    public function setSellerOrder(array $sellerOrder = array())
    {
        foreach ($sellerOrder as $orderSellerOrderItem) {
            // validation for constraint: itemType
            if (!$orderSellerOrderItem instanceof \StructType\SellerOrder) {
                throw new \InvalidArgumentException(sprintf('The SellerOrder property can only contain items of \StructType\SellerOrder, "%s" given', is_object($orderSellerOrderItem) ? get_class($orderSellerOrderItem) : gettype($orderSellerOrderItem)), __LINE__);
            }
        }
        $this->SellerOrder = $sellerOrder;
        return $this;
    }
    /**
     * Add item to SellerOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\SellerOrder $item
     * @return \StructType\Order
     */
    public function addToSellerOrder(\StructType\SellerOrder $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SellerOrder) {
            throw new \InvalidArgumentException(sprintf('The SellerOrder property can only contain items of \StructType\SellerOrder, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SellerOrder[] = $item;
        return $this;
    }
    /**
     * Get TotalGrossAmount value
     * @return float
     */
    public function getTotalGrossAmount()
    {
        return $this->TotalGrossAmount;
    }
    /**
     * Set TotalGrossAmount value
     * @param float $totalGrossAmount
     * @return \StructType\Order
     */
    public function setTotalGrossAmount($totalGrossAmount = null)
    {
        $this->TotalGrossAmount = $totalGrossAmount;
        return $this;
    }
    /**
     * Get TotalShippingCosts value
     * @return float
     */
    public function getTotalShippingCosts()
    {
        return $this->TotalShippingCosts;
    }
    /**
     * Set TotalShippingCosts value
     * @param float $totalShippingCosts
     * @return \StructType\Order
     */
    public function setTotalShippingCosts($totalShippingCosts = null)
    {
        $this->TotalShippingCosts = $totalShippingCosts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Order
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
