<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceAddress StructType
 * @subpackage Structs
 */
class InvoiceAddress extends Address
{
    /**
     * The VatId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VatId;
    /**
     * Constructor method for InvoiceAddress
     * @uses InvoiceAddress::setVatId()
     * @param string $vatId
     */
    public function __construct($vatId = null)
    {
        $this
            ->setVatId($vatId);
    }
    /**
     * Get VatId value
     * @return string|null
     */
    public function getVatId()
    {
        return $this->VatId;
    }
    /**
     * Set VatId value
     * @param string $vatId
     * @return \StructType\InvoiceAddress
     */
    public function setVatId($vatId = null)
    {
        // validation for constraint: string
        if (!is_null($vatId) && !is_string($vatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vatId)), __LINE__);
        }
        $this->VatId = $vatId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
