<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://webservice.s6.exacttarget.com/etframework.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://webservice.s6.exacttarget.com/etframework.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \App\Library\ExactTarget\ClassMap::get(),
);
/**
 * Samples for Create ServiceType
 */
$create = new \App\Library\ExactTarget\ServiceType\Create($options);
/**
 * Sample call for Create operation/method
 */
if ($create->Create(new \App\Library\ExactTarget\StructType\CreateRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Retrieve ServiceType
 */
$retrieve = new \App\Library\ExactTarget\ServiceType\Retrieve($options);
/**
 * Sample call for Retrieve operation/method
 */
if ($retrieve->Retrieve(new \App\Library\ExactTarget\StructType\RetrieveRequestMsg()) !== false) {
    print_r($retrieve->getResult());
} else {
    print_r($retrieve->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \App\Library\ExactTarget\ServiceType\Update($options);
/**
 * Sample call for Update operation/method
 */
if ($update->Update(new \App\Library\ExactTarget\StructType\UpdateRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \App\Library\ExactTarget\ServiceType\Delete($options);
/**
 * Sample call for Delete operation/method
 */
if ($delete->Delete(new \App\Library\ExactTarget\StructType\DeleteRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Query ServiceType
 */
$query = new \App\Library\ExactTarget\ServiceType\Query($options);
/**
 * Sample call for Query operation/method
 */
if ($query->Query(new \App\Library\ExactTarget\StructType\QueryRequestMsg()) !== false) {
    print_r($query->getResult());
} else {
    print_r($query->getLastError());
}
/**
 * Samples for Describe ServiceType
 */
$describe = new \App\Library\ExactTarget\ServiceType\Describe($options);
/**
 * Sample call for Describe operation/method
 */
if ($describe->Describe(new \App\Library\ExactTarget\StructType\DefinitionRequestMsg()) !== false) {
    print_r($describe->getResult());
} else {
    print_r($describe->getLastError());
}
/**
 * Samples for Execute ServiceType
 */
$execute = new \App\Library\ExactTarget\ServiceType\Execute($options);
/**
 * Sample call for Execute operation/method
 */
if ($execute->Execute(new \App\Library\ExactTarget\StructType\ExecuteRequestMsg()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Samples for Perform ServiceType
 */
$perform = new \App\Library\ExactTarget\ServiceType\Perform($options);
/**
 * Sample call for Perform operation/method
 */
if ($perform->Perform(new \App\Library\ExactTarget\StructType\PerformRequestMsg()) !== false) {
    print_r($perform->getResult());
} else {
    print_r($perform->getLastError());
}
/**
 * Samples for Configure ServiceType
 */
$configure = new \App\Library\ExactTarget\ServiceType\Configure($options);
/**
 * Sample call for Configure operation/method
 */
if ($configure->Configure(new \App\Library\ExactTarget\StructType\ConfigureRequestMsg()) !== false) {
    print_r($configure->getResult());
} else {
    print_r($configure->getLastError());
}
/**
 * Samples for Schedule ServiceType
 */
$schedule = new \App\Library\ExactTarget\ServiceType\Schedule($options);
/**
 * Sample call for Schedule operation/method
 */
if ($schedule->Schedule(new \App\Library\ExactTarget\StructType\ScheduleRequestMsg()) !== false) {
    print_r($schedule->getResult());
} else {
    print_r($schedule->getLastError());
}
/**
 * Samples for Version ServiceType
 */
$version = new \App\Library\ExactTarget\ServiceType\Version($options);
/**
 * Sample call for VersionInfo operation/method
 */
if ($version->VersionInfo(new \App\Library\ExactTarget\StructType\VersionInfoRequestMsg()) !== false) {
    print_r($version->getResult());
} else {
    print_r($version->getLastError());
}
/**
 * Samples for Extract ServiceType
 */
$extract = new \App\Library\ExactTarget\ServiceType\Extract($options);
/**
 * Sample call for Extract operation/method
 */
if ($extract->Extract(new \App\Library\ExactTarget\StructType\ExtractRequestMsg()) !== false) {
    print_r($extract->getResult());
} else {
    print_r($extract->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \App\Library\ExactTarget\ServiceType\Get($options);
/**
 * Sample call for GetSystemStatus operation/method
 */
if ($get->GetSystemStatus(new \App\Library\ExactTarget\StructType\SystemStatusRequestMsg()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
