<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for List StructType
 * Meta informations extracted from the WSDL
 * - type: tns:List
 * @subpackage Structs
 */
class _List extends APIObject
{
    /**
     * The ListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ListName;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Category;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Subscribers
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Subscriber[]
     */
    public $Subscribers;
    /**
     * The ListClassification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ListClassification;
    /**
     * The AutomatedEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Email
     */
    public $AutomatedEmail;
    /**
     * The SendClassification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SendClassification
     */
    public $SendClassification;
    /**
     * Constructor method for List
     * @uses _List::setListName()
     * @uses _List::setCategory()
     * @uses _List::setType()
     * @uses _List::setDescription()
     * @uses _List::setSubscribers()
     * @uses _List::setListClassification()
     * @uses _List::setAutomatedEmail()
     * @uses _List::setSendClassification()
     * @param string $listName
     * @param int $category
     * @param string $type
     * @param string $description
     * @param \App\Library\ExactTarget\StructType\Subscriber[] $subscribers
     * @param string $listClassification
     * @param \App\Library\ExactTarget\StructType\Email $automatedEmail
     * @param \App\Library\ExactTarget\StructType\SendClassification $sendClassification
     */
    public function __construct($listName = null, $category = null, $type = null, $description = null, array $subscribers = array(), $listClassification = null, \App\Library\ExactTarget\StructType\Email $automatedEmail = null, \App\Library\ExactTarget\StructType\SendClassification $sendClassification = null)
    {
        $this
            ->setListName($listName)
            ->setCategory($category)
            ->setType($type)
            ->setDescription($description)
            ->setSubscribers($subscribers)
            ->setListClassification($listClassification)
            ->setAutomatedEmail($automatedEmail)
            ->setSendClassification($sendClassification);
    }
    /**
     * Get ListName value
     * @return string|null
     */
    public function getListName()
    {
        return $this->ListName;
    }
    /**
     * Set ListName value
     * @param string $listName
     * @return \App\Library\ExactTarget\StructType\_List
     */
    public function setListName($listName = null)
    {
        // validation for constraint: string
        if (!is_null($listName) && !is_string($listName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listName)), __LINE__);
        }
        $this->ListName = $listName;
        return $this;
    }
    /**
     * Get Category value
     * @return int|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param int $category
     * @return \App\Library\ExactTarget\StructType\_List
     */
    public function setCategory($category = null)
    {
        // validation for constraint: int
        if (!is_null($category) && !is_numeric($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \App\Library\ExactTarget\EnumType\ListTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\ListTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \App\Library\ExactTarget\StructType\_List
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\ListTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \App\Library\ExactTarget\EnumType\ListTypeEnum::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\_List
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Subscribers value
     * @return \App\Library\ExactTarget\StructType\Subscriber[]|null
     */
    public function getSubscribers()
    {
        return $this->Subscribers;
    }
    /**
     * Set Subscribers value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Subscriber[] $subscribers
     * @return \App\Library\ExactTarget\StructType\_List
     */
    public function setSubscribers(array $subscribers = array())
    {
        foreach ($subscribers as $listSubscribersItem) {
            // validation for constraint: itemType
            if (!$listSubscribersItem instanceof \App\Library\ExactTarget\StructType\Subscriber) {
                throw new \InvalidArgumentException(sprintf('The Subscribers property can only contain items of \App\Library\ExactTarget\StructType\Subscriber, "%s" given', is_object($listSubscribersItem) ? get_class($listSubscribersItem) : gettype($listSubscribersItem)), __LINE__);
            }
        }
        $this->Subscribers = $subscribers;
        return $this;
    }
    /**
     * Add item to Subscribers value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Subscriber $item
     * @return \App\Library\ExactTarget\StructType\_List
     */
    public function addToSubscribers(\App\Library\ExactTarget\StructType\Subscriber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\Subscriber) {
            throw new \InvalidArgumentException(sprintf('The Subscribers property can only contain items of \App\Library\ExactTarget\StructType\Subscriber, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Subscribers[] = $item;
        return $this;
    }
    /**
     * Get ListClassification value
     * @return string|null
     */
    public function getListClassification()
    {
        return $this->ListClassification;
    }
    /**
     * Set ListClassification value
     * @uses \App\Library\ExactTarget\EnumType\ListClassificationEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\ListClassificationEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $listClassification
     * @return \App\Library\ExactTarget\StructType\_List
     */
    public function setListClassification($listClassification = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\ListClassificationEnum::valueIsValid($listClassification)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $listClassification, implode(', ', \App\Library\ExactTarget\EnumType\ListClassificationEnum::getValidValues())), __LINE__);
        }
        $this->ListClassification = $listClassification;
        return $this;
    }
    /**
     * Get AutomatedEmail value
     * @return \App\Library\ExactTarget\StructType\Email|null
     */
    public function getAutomatedEmail()
    {
        return $this->AutomatedEmail;
    }
    /**
     * Set AutomatedEmail value
     * @param \App\Library\ExactTarget\StructType\Email $automatedEmail
     * @return \App\Library\ExactTarget\StructType\_List
     */
    public function setAutomatedEmail(\App\Library\ExactTarget\StructType\Email $automatedEmail = null)
    {
        $this->AutomatedEmail = $automatedEmail;
        return $this;
    }
    /**
     * Get SendClassification value
     * @return \App\Library\ExactTarget\StructType\SendClassification|null
     */
    public function getSendClassification()
    {
        return $this->SendClassification;
    }
    /**
     * Set SendClassification value
     * @param \App\Library\ExactTarget\StructType\SendClassification $sendClassification
     * @return \App\Library\ExactTarget\StructType\_List
     */
    public function setSendClassification(\App\Library\ExactTarget\StructType\SendClassification $sendClassification = null)
    {
        $this->SendClassification = $sendClassification;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\_List
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
