<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for YearlyRecurrence StructType
 * Meta informations extracted from the WSDL
 * - type: tns:YearlyRecurrence
 * @subpackage Structs
 */
class YearlyRecurrence extends Recurrence
{
    /**
     * The YearlyRecurrencePatternType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $YearlyRecurrencePatternType;
    /**
     * The ScheduledDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ScheduledDay;
    /**
     * The ScheduledWeek
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledWeek;
    /**
     * The ScheduledMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledMonth;
    /**
     * The ScheduledDayOfWeek
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ScheduledDayOfWeek;
    /**
     * Constructor method for YearlyRecurrence
     * @uses YearlyRecurrence::setYearlyRecurrencePatternType()
     * @uses YearlyRecurrence::setScheduledDay()
     * @uses YearlyRecurrence::setScheduledWeek()
     * @uses YearlyRecurrence::setScheduledMonth()
     * @uses YearlyRecurrence::setScheduledDayOfWeek()
     * @param string $yearlyRecurrencePatternType
     * @param int $scheduledDay
     * @param string $scheduledWeek
     * @param string $scheduledMonth
     * @param string $scheduledDayOfWeek
     */
    public function __construct($yearlyRecurrencePatternType = null, $scheduledDay = null, $scheduledWeek = null, $scheduledMonth = null, $scheduledDayOfWeek = null)
    {
        $this
            ->setYearlyRecurrencePatternType($yearlyRecurrencePatternType)
            ->setScheduledDay($scheduledDay)
            ->setScheduledWeek($scheduledWeek)
            ->setScheduledMonth($scheduledMonth)
            ->setScheduledDayOfWeek($scheduledDayOfWeek);
    }
    /**
     * Get YearlyRecurrencePatternType value
     * @return string|null
     */
    public function getYearlyRecurrencePatternType()
    {
        return $this->YearlyRecurrencePatternType;
    }
    /**
     * Set YearlyRecurrencePatternType value
     * @uses \App\Library\ExactTarget\EnumType\YearlyRecurrencePatternTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\YearlyRecurrencePatternTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $yearlyRecurrencePatternType
     * @return \App\Library\ExactTarget\StructType\YearlyRecurrence
     */
    public function setYearlyRecurrencePatternType($yearlyRecurrencePatternType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\YearlyRecurrencePatternTypeEnum::valueIsValid($yearlyRecurrencePatternType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $yearlyRecurrencePatternType, implode(', ', \App\Library\ExactTarget\EnumType\YearlyRecurrencePatternTypeEnum::getValidValues())), __LINE__);
        }
        $this->YearlyRecurrencePatternType = $yearlyRecurrencePatternType;
        return $this;
    }
    /**
     * Get ScheduledDay value
     * @return int|null
     */
    public function getScheduledDay()
    {
        return $this->ScheduledDay;
    }
    /**
     * Set ScheduledDay value
     * @param int $scheduledDay
     * @return \App\Library\ExactTarget\StructType\YearlyRecurrence
     */
    public function setScheduledDay($scheduledDay = null)
    {
        // validation for constraint: int
        if (!is_null($scheduledDay) && !is_numeric($scheduledDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($scheduledDay)), __LINE__);
        }
        $this->ScheduledDay = $scheduledDay;
        return $this;
    }
    /**
     * Get ScheduledWeek value
     * @return string|null
     */
    public function getScheduledWeek()
    {
        return $this->ScheduledWeek;
    }
    /**
     * Set ScheduledWeek value
     * @uses \App\Library\ExactTarget\EnumType\WeekOfMonthEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\WeekOfMonthEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduledWeek
     * @return \App\Library\ExactTarget\StructType\YearlyRecurrence
     */
    public function setScheduledWeek($scheduledWeek = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\WeekOfMonthEnum::valueIsValid($scheduledWeek)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scheduledWeek, implode(', ', \App\Library\ExactTarget\EnumType\WeekOfMonthEnum::getValidValues())), __LINE__);
        }
        $this->ScheduledWeek = $scheduledWeek;
        return $this;
    }
    /**
     * Get ScheduledMonth value
     * @return string|null
     */
    public function getScheduledMonth()
    {
        return $this->ScheduledMonth;
    }
    /**
     * Set ScheduledMonth value
     * @uses \App\Library\ExactTarget\EnumType\MonthOfYearEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\MonthOfYearEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduledMonth
     * @return \App\Library\ExactTarget\StructType\YearlyRecurrence
     */
    public function setScheduledMonth($scheduledMonth = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\MonthOfYearEnum::valueIsValid($scheduledMonth)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scheduledMonth, implode(', ', \App\Library\ExactTarget\EnumType\MonthOfYearEnum::getValidValues())), __LINE__);
        }
        $this->ScheduledMonth = $scheduledMonth;
        return $this;
    }
    /**
     * Get ScheduledDayOfWeek value
     * @return string|null
     */
    public function getScheduledDayOfWeek()
    {
        return $this->ScheduledDayOfWeek;
    }
    /**
     * Set ScheduledDayOfWeek value
     * @uses \App\Library\ExactTarget\EnumType\DayOfWeekEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\DayOfWeekEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scheduledDayOfWeek
     * @return \App\Library\ExactTarget\StructType\YearlyRecurrence
     */
    public function setScheduledDayOfWeek($scheduledDayOfWeek = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\DayOfWeekEnum::valueIsValid($scheduledDayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $scheduledDayOfWeek, implode(', ', \App\Library\ExactTarget\EnumType\DayOfWeekEnum::getValidValues())), __LINE__);
        }
        $this->ScheduledDayOfWeek = $scheduledDayOfWeek;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\YearlyRecurrence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
