<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VersionInfoResponse StructType
 * @subpackage Structs
 */
class VersionInfoResponse extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Version;
    /**
     * The VersionDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VersionDate;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Notes;
    /**
     * The VersionHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\VersionInfoResponse[]
     */
    public $VersionHistory;
    /**
     * Constructor method for VersionInfoResponse
     * @uses VersionInfoResponse::setVersion()
     * @uses VersionInfoResponse::setVersionDate()
     * @uses VersionInfoResponse::setNotes()
     * @uses VersionInfoResponse::setVersionHistory()
     * @param string $version
     * @param string $versionDate
     * @param string $notes
     * @param \App\Library\ExactTarget\StructType\VersionInfoResponse[] $versionHistory
     */
    public function __construct($version = null, $versionDate = null, $notes = null, array $versionHistory = array())
    {
        $this
            ->setVersion($version)
            ->setVersionDate($versionDate)
            ->setNotes($notes)
            ->setVersionHistory($versionHistory);
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \App\Library\ExactTarget\StructType\VersionInfoResponse
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get VersionDate value
     * @return string
     */
    public function getVersionDate()
    {
        return $this->VersionDate;
    }
    /**
     * Set VersionDate value
     * @param string $versionDate
     * @return \App\Library\ExactTarget\StructType\VersionInfoResponse
     */
    public function setVersionDate($versionDate = null)
    {
        // validation for constraint: string
        if (!is_null($versionDate) && !is_string($versionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versionDate)), __LINE__);
        }
        $this->VersionDate = $versionDate;
        return $this;
    }
    /**
     * Get Notes value
     * @return string
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \App\Library\ExactTarget\StructType\VersionInfoResponse
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get VersionHistory value
     * @return \App\Library\ExactTarget\StructType\VersionInfoResponse[]|null
     */
    public function getVersionHistory()
    {
        return $this->VersionHistory;
    }
    /**
     * Set VersionHistory value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\VersionInfoResponse[] $versionHistory
     * @return \App\Library\ExactTarget\StructType\VersionInfoResponse
     */
    public function setVersionHistory(array $versionHistory = array())
    {
        foreach ($versionHistory as $versionInfoResponseVersionHistoryItem) {
            // validation for constraint: itemType
            if (!$versionInfoResponseVersionHistoryItem instanceof \App\Library\ExactTarget\StructType\VersionInfoResponse) {
                throw new \InvalidArgumentException(sprintf('The VersionHistory property can only contain items of \App\Library\ExactTarget\StructType\VersionInfoResponse, "%s" given', is_object($versionInfoResponseVersionHistoryItem) ? get_class($versionInfoResponseVersionHistoryItem) : gettype($versionInfoResponseVersionHistoryItem)), __LINE__);
            }
        }
        $this->VersionHistory = $versionHistory;
        return $this;
    }
    /**
     * Add item to VersionHistory value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\VersionInfoResponse $item
     * @return \App\Library\ExactTarget\StructType\VersionInfoResponse
     */
    public function addToVersionHistory(\App\Library\ExactTarget\StructType\VersionInfoResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\VersionInfoResponse) {
            throw new \InvalidArgumentException(sprintf('The VersionHistory property can only contain items of \App\Library\ExactTarget\StructType\VersionInfoResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VersionHistory[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\VersionInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
