<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValueErrors StructType
 * @subpackage Structs
 */
class ValueErrors extends AbstractStructBase
{
    /**
     * The ValueError
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\DataExtensionError[]
     */
    public $ValueError;
    /**
     * Constructor method for ValueErrors
     * @uses ValueErrors::setValueError()
     * @param \App\Library\ExactTarget\StructType\DataExtensionError[] $valueError
     */
    public function __construct(array $valueError = array())
    {
        $this
            ->setValueError($valueError);
    }
    /**
     * Get ValueError value
     * @return \App\Library\ExactTarget\StructType\DataExtensionError[]|null
     */
    public function getValueError()
    {
        return $this->ValueError;
    }
    /**
     * Set ValueError value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\DataExtensionError[] $valueError
     * @return \App\Library\ExactTarget\StructType\ValueErrors
     */
    public function setValueError(array $valueError = array())
    {
        foreach ($valueError as $valueErrorsValueErrorItem) {
            // validation for constraint: itemType
            if (!$valueErrorsValueErrorItem instanceof \App\Library\ExactTarget\StructType\DataExtensionError) {
                throw new \InvalidArgumentException(sprintf('The ValueError property can only contain items of \App\Library\ExactTarget\StructType\DataExtensionError, "%s" given', is_object($valueErrorsValueErrorItem) ? get_class($valueErrorsValueErrorItem) : gettype($valueErrorsValueErrorItem)), __LINE__);
            }
        }
        $this->ValueError = $valueError;
        return $this;
    }
    /**
     * Add item to ValueError value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\DataExtensionError $item
     * @return \App\Library\ExactTarget\StructType\ValueErrors
     */
    public function addToValueError(\App\Library\ExactTarget\StructType\DataExtensionError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\DataExtensionError) {
            throw new \InvalidArgumentException(sprintf('The ValueError property can only contain items of \App\Library\ExactTarget\StructType\DataExtensionError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ValueError[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ValueErrors
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
