<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationResult StructType
 * @subpackage Structs
 */
class ValidationResult extends AbstractStructBase
{
    /**
     * The Subscriber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Subscriber
     */
    public $Subscriber;
    /**
     * The CheckTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckTime;
    /**
     * The CheckTimeUTC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckTimeUTC;
    /**
     * The IsResultValid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsResultValid;
    /**
     * The IsSpam
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsSpam;
    /**
     * The Score
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Score;
    /**
     * The Threshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $Threshold;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for ValidationResult
     * @uses ValidationResult::setSubscriber()
     * @uses ValidationResult::setCheckTime()
     * @uses ValidationResult::setCheckTimeUTC()
     * @uses ValidationResult::setIsResultValid()
     * @uses ValidationResult::setIsSpam()
     * @uses ValidationResult::setScore()
     * @uses ValidationResult::setThreshold()
     * @uses ValidationResult::setMessage()
     * @param \App\Library\ExactTarget\StructType\Subscriber $subscriber
     * @param string $checkTime
     * @param string $checkTimeUTC
     * @param bool $isResultValid
     * @param bool $isSpam
     * @param float $score
     * @param float $threshold
     * @param string $message
     */
    public function __construct(\App\Library\ExactTarget\StructType\Subscriber $subscriber = null, $checkTime = null, $checkTimeUTC = null, $isResultValid = null, $isSpam = null, $score = null, $threshold = null, $message = null)
    {
        $this
            ->setSubscriber($subscriber)
            ->setCheckTime($checkTime)
            ->setCheckTimeUTC($checkTimeUTC)
            ->setIsResultValid($isResultValid)
            ->setIsSpam($isSpam)
            ->setScore($score)
            ->setThreshold($threshold)
            ->setMessage($message);
    }
    /**
     * Get Subscriber value
     * @return \App\Library\ExactTarget\StructType\Subscriber|null
     */
    public function getSubscriber()
    {
        return $this->Subscriber;
    }
    /**
     * Set Subscriber value
     * @param \App\Library\ExactTarget\StructType\Subscriber $subscriber
     * @return \App\Library\ExactTarget\StructType\ValidationResult
     */
    public function setSubscriber(\App\Library\ExactTarget\StructType\Subscriber $subscriber = null)
    {
        $this->Subscriber = $subscriber;
        return $this;
    }
    /**
     * Get CheckTime value
     * @return string|null
     */
    public function getCheckTime()
    {
        return $this->CheckTime;
    }
    /**
     * Set CheckTime value
     * @param string $checkTime
     * @return \App\Library\ExactTarget\StructType\ValidationResult
     */
    public function setCheckTime($checkTime = null)
    {
        // validation for constraint: string
        if (!is_null($checkTime) && !is_string($checkTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkTime)), __LINE__);
        }
        $this->CheckTime = $checkTime;
        return $this;
    }
    /**
     * Get CheckTimeUTC value
     * @return string|null
     */
    public function getCheckTimeUTC()
    {
        return $this->CheckTimeUTC;
    }
    /**
     * Set CheckTimeUTC value
     * @param string $checkTimeUTC
     * @return \App\Library\ExactTarget\StructType\ValidationResult
     */
    public function setCheckTimeUTC($checkTimeUTC = null)
    {
        // validation for constraint: string
        if (!is_null($checkTimeUTC) && !is_string($checkTimeUTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkTimeUTC)), __LINE__);
        }
        $this->CheckTimeUTC = $checkTimeUTC;
        return $this;
    }
    /**
     * Get IsResultValid value
     * @return bool|null
     */
    public function getIsResultValid()
    {
        return $this->IsResultValid;
    }
    /**
     * Set IsResultValid value
     * @param bool $isResultValid
     * @return \App\Library\ExactTarget\StructType\ValidationResult
     */
    public function setIsResultValid($isResultValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResultValid) && !is_bool($isResultValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isResultValid)), __LINE__);
        }
        $this->IsResultValid = $isResultValid;
        return $this;
    }
    /**
     * Get IsSpam value
     * @return bool|null
     */
    public function getIsSpam()
    {
        return $this->IsSpam;
    }
    /**
     * Set IsSpam value
     * @param bool $isSpam
     * @return \App\Library\ExactTarget\StructType\ValidationResult
     */
    public function setIsSpam($isSpam = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSpam) && !is_bool($isSpam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSpam)), __LINE__);
        }
        $this->IsSpam = $isSpam;
        return $this;
    }
    /**
     * Get Score value
     * @return float|null
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param float $score
     * @return \App\Library\ExactTarget\StructType\ValidationResult
     */
    public function setScore($score = null)
    {
        $this->Score = $score;
        return $this;
    }
    /**
     * Get Threshold value
     * @return float|null
     */
    public function getThreshold()
    {
        return $this->Threshold;
    }
    /**
     * Set Threshold value
     * @param float $threshold
     * @return \App\Library\ExactTarget\StructType\ValidationResult
     */
    public function setThreshold($threshold = null)
    {
        $this->Threshold = $threshold;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \App\Library\ExactTarget\StructType\ValidationResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ValidationResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
