<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UsernameAuthentication StructType
 * @subpackage Structs
 */
class UsernameAuthentication extends Authentication
{
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The PassWord
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PassWord;
    /**
     * Constructor method for UsernameAuthentication
     * @uses UsernameAuthentication::setUserName()
     * @uses UsernameAuthentication::setPassWord()
     * @param string $userName
     * @param string $passWord
     */
    public function __construct($userName = null, $passWord = null)
    {
        $this
            ->setUserName($userName)
            ->setPassWord($passWord);
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \App\Library\ExactTarget\StructType\UsernameAuthentication
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get PassWord value
     * @return string|null
     */
    public function getPassWord()
    {
        return $this->PassWord;
    }
    /**
     * Set PassWord value
     * @param string $passWord
     * @return \App\Library\ExactTarget\StructType\UsernameAuthentication
     */
    public function setPassWord($passWord = null)
    {
        // validation for constraint: string
        if (!is_null($passWord) && !is_string($passWord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passWord)), __LINE__);
        }
        $this->PassWord = $passWord;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\UsernameAuthentication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
