<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserMap StructType
 * @subpackage Structs
 */
class UserMap extends APIProperty
{
    /**
     * The ETAccountUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\AccountUser
     */
    public $ETAccountUser;
    /**
     * The AdditionalData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIProperty[]
     */
    public $AdditionalData;
    /**
     * Constructor method for UserMap
     * @uses UserMap::setETAccountUser()
     * @uses UserMap::setAdditionalData()
     * @param \App\Library\ExactTarget\StructType\AccountUser $eTAccountUser
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $additionalData
     */
    public function __construct(\App\Library\ExactTarget\StructType\AccountUser $eTAccountUser = null, array $additionalData = array())
    {
        $this
            ->setETAccountUser($eTAccountUser)
            ->setAdditionalData($additionalData);
    }
    /**
     * Get ETAccountUser value
     * @return \App\Library\ExactTarget\StructType\AccountUser
     */
    public function getETAccountUser()
    {
        return $this->ETAccountUser;
    }
    /**
     * Set ETAccountUser value
     * @param \App\Library\ExactTarget\StructType\AccountUser $eTAccountUser
     * @return \App\Library\ExactTarget\StructType\UserMap
     */
    public function setETAccountUser(\App\Library\ExactTarget\StructType\AccountUser $eTAccountUser = null)
    {
        $this->ETAccountUser = $eTAccountUser;
        return $this;
    }
    /**
     * Get AdditionalData value
     * @return \App\Library\ExactTarget\StructType\APIProperty[]|null
     */
    public function getAdditionalData()
    {
        return $this->AdditionalData;
    }
    /**
     * Set AdditionalData value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $additionalData
     * @return \App\Library\ExactTarget\StructType\UserMap
     */
    public function setAdditionalData(array $additionalData = array())
    {
        foreach ($additionalData as $userMapAdditionalDataItem) {
            // validation for constraint: itemType
            if (!$userMapAdditionalDataItem instanceof \App\Library\ExactTarget\StructType\APIProperty) {
                throw new \InvalidArgumentException(sprintf('The AdditionalData property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($userMapAdditionalDataItem) ? get_class($userMapAdditionalDataItem) : gettype($userMapAdditionalDataItem)), __LINE__);
            }
        }
        $this->AdditionalData = $additionalData;
        return $this;
    }
    /**
     * Add item to AdditionalData value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty $item
     * @return \App\Library\ExactTarget\StructType\UserMap
     */
    public function addToAdditionalData(\App\Library\ExactTarget\StructType\APIProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIProperty) {
            throw new \InvalidArgumentException(sprintf('The AdditionalData property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdditionalData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\UserMap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
