<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateResult StructType
 * @subpackage Structs
 */
class UpdateResult extends Result
{
    /**
     * The Object
     * @var \App\Library\ExactTarget\StructType\APIObject
     */
    public $Object;
    /**
     * The UpdateResults
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\UpdateResult[]
     */
    public $UpdateResults;
    /**
     * The ParentPropertyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ParentPropertyName;
    /**
     * Constructor method for UpdateResult
     * @uses UpdateResult::setObject()
     * @uses UpdateResult::setUpdateResults()
     * @uses UpdateResult::setParentPropertyName()
     * @param \App\Library\ExactTarget\StructType\APIObject $object
     * @param \App\Library\ExactTarget\StructType\UpdateResult[] $updateResults
     * @param string $parentPropertyName
     */
    public function __construct(\App\Library\ExactTarget\StructType\APIObject $object = null, array $updateResults = array(), $parentPropertyName = null)
    {
        $this
            ->setObject($object)
            ->setUpdateResults($updateResults)
            ->setParentPropertyName($parentPropertyName);
    }
    /**
     * Get Object value
     * @return \App\Library\ExactTarget\StructType\APIObject|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * Set Object value
     * @param \App\Library\ExactTarget\StructType\APIObject $object
     * @return \App\Library\ExactTarget\StructType\UpdateResult
     */
    public function setObject(\App\Library\ExactTarget\StructType\APIObject $object = null)
    {
        $this->Object = $object;
        return $this;
    }
    /**
     * Get UpdateResults value
     * @return \App\Library\ExactTarget\StructType\UpdateResult[]|null
     */
    public function getUpdateResults()
    {
        return $this->UpdateResults;
    }
    /**
     * Set UpdateResults value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\UpdateResult[] $updateResults
     * @return \App\Library\ExactTarget\StructType\UpdateResult
     */
    public function setUpdateResults(array $updateResults = array())
    {
        foreach ($updateResults as $updateResultUpdateResultsItem) {
            // validation for constraint: itemType
            if (!$updateResultUpdateResultsItem instanceof \App\Library\ExactTarget\StructType\UpdateResult) {
                throw new \InvalidArgumentException(sprintf('The UpdateResults property can only contain items of \App\Library\ExactTarget\StructType\UpdateResult, "%s" given', is_object($updateResultUpdateResultsItem) ? get_class($updateResultUpdateResultsItem) : gettype($updateResultUpdateResultsItem)), __LINE__);
            }
        }
        $this->UpdateResults = $updateResults;
        return $this;
    }
    /**
     * Add item to UpdateResults value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\UpdateResult $item
     * @return \App\Library\ExactTarget\StructType\UpdateResult
     */
    public function addToUpdateResults(\App\Library\ExactTarget\StructType\UpdateResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\UpdateResult) {
            throw new \InvalidArgumentException(sprintf('The UpdateResults property can only contain items of \App\Library\ExactTarget\StructType\UpdateResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UpdateResults[] = $item;
        return $this;
    }
    /**
     * Get ParentPropertyName value
     * @return string|null
     */
    public function getParentPropertyName()
    {
        return $this->ParentPropertyName;
    }
    /**
     * Set ParentPropertyName value
     * @param string $parentPropertyName
     * @return \App\Library\ExactTarget\StructType\UpdateResult
     */
    public function setParentPropertyName($parentPropertyName = null)
    {
        // validation for constraint: string
        if (!is_null($parentPropertyName) && !is_string($parentPropertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($parentPropertyName)), __LINE__);
        }
        $this->ParentPropertyName = $parentPropertyName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\UpdateResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
