<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TriggeredSendDefinition StructType
 * Meta informations extracted from the WSDL
 * - type: tns:TriggeredSendDefinition
 * @subpackage Structs
 */
class TriggeredSendDefinition extends SendDefinition
{
    /**
     * The TriggeredSendType
     * Meta informations extracted from the WSDL
     * - documentation: Always will be set to Continuous. For additional fee, TriggeredSendDefinition.Priority can be used to adjust priority.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TriggeredSendType;
    /**
     * The TriggeredSendStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TriggeredSendStatus;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Email
     */
    public $Email;
    /**
     * The List
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\_List
     */
    public $List;
    /**
     * The AutoAddSubscribers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AutoAddSubscribers;
    /**
     * The AutoUpdateSubscribers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $AutoUpdateSubscribers;
    /**
     * The BatchInterval
     * Meta informations extracted from the WSDL
     * - documentation: Always will be set to 1. For additional fee, TriggeredSendDefinition.Priority can be used to adjust priority.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $BatchInterval;
    /**
     * The BccEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BccEmail;
    /**
     * The EmailSubject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailSubject;
    /**
     * The DynamicEmailSubject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DynamicEmailSubject;
    /**
     * The IsMultipart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsMultipart;
    /**
     * The IsWrapped
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsWrapped;
    /**
     * The AllowedSlots
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $AllowedSlots;
    /**
     * The NewSlotTrigger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $NewSlotTrigger;
    /**
     * The SendLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SendLimit;
    /**
     * The SendWindowOpen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendWindowOpen;
    /**
     * The SendWindowClose
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendWindowClose;
    /**
     * The SendWindowDelete
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SendWindowDelete;
    /**
     * The RefreshContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RefreshContent;
    /**
     * The ExclusionFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExclusionFilter;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Priority;
    /**
     * The SendSourceCustomerKey
     * Meta informations extracted from the WSDL
     * - documentation: Deprecated. Use SendSourceDataExtension instead.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendSourceCustomerKey;
    /**
     * The ExclusionListCollection
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\TriggeredSendExclusionList[]
     */
    public $ExclusionListCollection;
    /**
     * The CCEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CCEmail;
    /**
     * The SendSourceDataExtension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\DataExtension
     */
    public $SendSourceDataExtension;
    /**
     * The IsAlwaysOn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsAlwaysOn;
    /**
     * The DisableOnEmailBuildError
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $DisableOnEmailBuildError;
    /**
     * The PreHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PreHeader;
    /**
     * The ReplyToAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReplyToAddress;
    /**
     * The ReplyToDisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReplyToDisplayName;
    /**
     * The TriggeredSendClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TriggeredSendClass;
    /**
     * The TriggeredSendSubClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TriggeredSendSubClass;
    /**
     * Constructor method for TriggeredSendDefinition
     * @uses TriggeredSendDefinition::setTriggeredSendType()
     * @uses TriggeredSendDefinition::setTriggeredSendStatus()
     * @uses TriggeredSendDefinition::setEmail()
     * @uses TriggeredSendDefinition::setList()
     * @uses TriggeredSendDefinition::setAutoAddSubscribers()
     * @uses TriggeredSendDefinition::setAutoUpdateSubscribers()
     * @uses TriggeredSendDefinition::setBatchInterval()
     * @uses TriggeredSendDefinition::setBccEmail()
     * @uses TriggeredSendDefinition::setEmailSubject()
     * @uses TriggeredSendDefinition::setDynamicEmailSubject()
     * @uses TriggeredSendDefinition::setIsMultipart()
     * @uses TriggeredSendDefinition::setIsWrapped()
     * @uses TriggeredSendDefinition::setAllowedSlots()
     * @uses TriggeredSendDefinition::setNewSlotTrigger()
     * @uses TriggeredSendDefinition::setSendLimit()
     * @uses TriggeredSendDefinition::setSendWindowOpen()
     * @uses TriggeredSendDefinition::setSendWindowClose()
     * @uses TriggeredSendDefinition::setSendWindowDelete()
     * @uses TriggeredSendDefinition::setRefreshContent()
     * @uses TriggeredSendDefinition::setExclusionFilter()
     * @uses TriggeredSendDefinition::setPriority()
     * @uses TriggeredSendDefinition::setSendSourceCustomerKey()
     * @uses TriggeredSendDefinition::setExclusionListCollection()
     * @uses TriggeredSendDefinition::setCCEmail()
     * @uses TriggeredSendDefinition::setSendSourceDataExtension()
     * @uses TriggeredSendDefinition::setIsAlwaysOn()
     * @uses TriggeredSendDefinition::setDisableOnEmailBuildError()
     * @uses TriggeredSendDefinition::setPreHeader()
     * @uses TriggeredSendDefinition::setReplyToAddress()
     * @uses TriggeredSendDefinition::setReplyToDisplayName()
     * @uses TriggeredSendDefinition::setTriggeredSendClass()
     * @uses TriggeredSendDefinition::setTriggeredSendSubClass()
     * @param string $triggeredSendType
     * @param string $triggeredSendStatus
     * @param \App\Library\ExactTarget\StructType\Email $email
     * @param \App\Library\ExactTarget\StructType\_List $list
     * @param bool $autoAddSubscribers
     * @param bool $autoUpdateSubscribers
     * @param int $batchInterval
     * @param string $bccEmail
     * @param string $emailSubject
     * @param string $dynamicEmailSubject
     * @param bool $isMultipart
     * @param bool $isWrapped
     * @param int $allowedSlots
     * @param int $newSlotTrigger
     * @param int $sendLimit
     * @param string $sendWindowOpen
     * @param string $sendWindowClose
     * @param bool $sendWindowDelete
     * @param bool $refreshContent
     * @param string $exclusionFilter
     * @param string $priority
     * @param string $sendSourceCustomerKey
     * @param \App\Library\ExactTarget\StructType\TriggeredSendExclusionList[] $exclusionListCollection
     * @param string $cCEmail
     * @param \App\Library\ExactTarget\StructType\DataExtension $sendSourceDataExtension
     * @param bool $isAlwaysOn
     * @param bool $disableOnEmailBuildError
     * @param string $preHeader
     * @param string $replyToAddress
     * @param string $replyToDisplayName
     * @param string $triggeredSendClass
     * @param string $triggeredSendSubClass
     */
    public function __construct($triggeredSendType = null, $triggeredSendStatus = null, \App\Library\ExactTarget\StructType\Email $email = null, \App\Library\ExactTarget\StructType\_List $list = null, $autoAddSubscribers = null, $autoUpdateSubscribers = null, $batchInterval = null, $bccEmail = null, $emailSubject = null, $dynamicEmailSubject = null, $isMultipart = null, $isWrapped = null, $allowedSlots = null, $newSlotTrigger = null, $sendLimit = null, $sendWindowOpen = null, $sendWindowClose = null, $sendWindowDelete = null, $refreshContent = null, $exclusionFilter = null, $priority = null, $sendSourceCustomerKey = null, array $exclusionListCollection = array(), $cCEmail = null, \App\Library\ExactTarget\StructType\DataExtension $sendSourceDataExtension = null, $isAlwaysOn = null, $disableOnEmailBuildError = null, $preHeader = null, $replyToAddress = null, $replyToDisplayName = null, $triggeredSendClass = null, $triggeredSendSubClass = null)
    {
        $this
            ->setTriggeredSendType($triggeredSendType)
            ->setTriggeredSendStatus($triggeredSendStatus)
            ->setEmail($email)
            ->setList($list)
            ->setAutoAddSubscribers($autoAddSubscribers)
            ->setAutoUpdateSubscribers($autoUpdateSubscribers)
            ->setBatchInterval($batchInterval)
            ->setBccEmail($bccEmail)
            ->setEmailSubject($emailSubject)
            ->setDynamicEmailSubject($dynamicEmailSubject)
            ->setIsMultipart($isMultipart)
            ->setIsWrapped($isWrapped)
            ->setAllowedSlots($allowedSlots)
            ->setNewSlotTrigger($newSlotTrigger)
            ->setSendLimit($sendLimit)
            ->setSendWindowOpen($sendWindowOpen)
            ->setSendWindowClose($sendWindowClose)
            ->setSendWindowDelete($sendWindowDelete)
            ->setRefreshContent($refreshContent)
            ->setExclusionFilter($exclusionFilter)
            ->setPriority($priority)
            ->setSendSourceCustomerKey($sendSourceCustomerKey)
            ->setExclusionListCollection($exclusionListCollection)
            ->setCCEmail($cCEmail)
            ->setSendSourceDataExtension($sendSourceDataExtension)
            ->setIsAlwaysOn($isAlwaysOn)
            ->setDisableOnEmailBuildError($disableOnEmailBuildError)
            ->setPreHeader($preHeader)
            ->setReplyToAddress($replyToAddress)
            ->setReplyToDisplayName($replyToDisplayName)
            ->setTriggeredSendClass($triggeredSendClass)
            ->setTriggeredSendSubClass($triggeredSendSubClass);
    }
    /**
     * Get TriggeredSendType value
     * @return string|null
     */
    public function getTriggeredSendType()
    {
        return $this->TriggeredSendType;
    }
    /**
     * Set TriggeredSendType value
     * @uses \App\Library\ExactTarget\EnumType\TriggeredSendTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\TriggeredSendTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $triggeredSendType
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setTriggeredSendType($triggeredSendType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\TriggeredSendTypeEnum::valueIsValid($triggeredSendType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $triggeredSendType, implode(', ', \App\Library\ExactTarget\EnumType\TriggeredSendTypeEnum::getValidValues())), __LINE__);
        }
        $this->TriggeredSendType = $triggeredSendType;
        return $this;
    }
    /**
     * Get TriggeredSendStatus value
     * @return string|null
     */
    public function getTriggeredSendStatus()
    {
        return $this->TriggeredSendStatus;
    }
    /**
     * Set TriggeredSendStatus value
     * @uses \App\Library\ExactTarget\EnumType\TriggeredSendStatusEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\TriggeredSendStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $triggeredSendStatus
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setTriggeredSendStatus($triggeredSendStatus = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\TriggeredSendStatusEnum::valueIsValid($triggeredSendStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $triggeredSendStatus, implode(', ', \App\Library\ExactTarget\EnumType\TriggeredSendStatusEnum::getValidValues())), __LINE__);
        }
        $this->TriggeredSendStatus = $triggeredSendStatus;
        return $this;
    }
    /**
     * Get Email value
     * @return \App\Library\ExactTarget\StructType\Email|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \App\Library\ExactTarget\StructType\Email $email
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setEmail(\App\Library\ExactTarget\StructType\Email $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get List value
     * @return \App\Library\ExactTarget\StructType\_List|null
     */
    public function getList()
    {
        return $this->List;
    }
    /**
     * Set List value
     * @param \App\Library\ExactTarget\StructType\_List $list
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setList(\App\Library\ExactTarget\StructType\_List $list = null)
    {
        $this->List = $list;
        return $this;
    }
    /**
     * Get AutoAddSubscribers value
     * @return bool|null
     */
    public function getAutoAddSubscribers()
    {
        return $this->AutoAddSubscribers;
    }
    /**
     * Set AutoAddSubscribers value
     * @param bool $autoAddSubscribers
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setAutoAddSubscribers($autoAddSubscribers = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoAddSubscribers) && !is_bool($autoAddSubscribers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($autoAddSubscribers)), __LINE__);
        }
        $this->AutoAddSubscribers = $autoAddSubscribers;
        return $this;
    }
    /**
     * Get AutoUpdateSubscribers value
     * @return bool|null
     */
    public function getAutoUpdateSubscribers()
    {
        return $this->AutoUpdateSubscribers;
    }
    /**
     * Set AutoUpdateSubscribers value
     * @param bool $autoUpdateSubscribers
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setAutoUpdateSubscribers($autoUpdateSubscribers = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoUpdateSubscribers) && !is_bool($autoUpdateSubscribers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($autoUpdateSubscribers)), __LINE__);
        }
        $this->AutoUpdateSubscribers = $autoUpdateSubscribers;
        return $this;
    }
    /**
     * Get BatchInterval value
     * @return int|null
     */
    public function getBatchInterval()
    {
        return $this->BatchInterval;
    }
    /**
     * Set BatchInterval value
     * @param int $batchInterval
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setBatchInterval($batchInterval = null)
    {
        // validation for constraint: int
        if (!is_null($batchInterval) && !is_numeric($batchInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($batchInterval)), __LINE__);
        }
        $this->BatchInterval = $batchInterval;
        return $this;
    }
    /**
     * Get BccEmail value
     * @return string|null
     */
    public function getBccEmail()
    {
        return $this->BccEmail;
    }
    /**
     * Set BccEmail value
     * @param string $bccEmail
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setBccEmail($bccEmail = null)
    {
        // validation for constraint: string
        if (!is_null($bccEmail) && !is_string($bccEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bccEmail)), __LINE__);
        }
        $this->BccEmail = $bccEmail;
        return $this;
    }
    /**
     * Get EmailSubject value
     * @return string|null
     */
    public function getEmailSubject()
    {
        return $this->EmailSubject;
    }
    /**
     * Set EmailSubject value
     * @param string $emailSubject
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setEmailSubject($emailSubject = null)
    {
        // validation for constraint: string
        if (!is_null($emailSubject) && !is_string($emailSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailSubject)), __LINE__);
        }
        $this->EmailSubject = $emailSubject;
        return $this;
    }
    /**
     * Get DynamicEmailSubject value
     * @return string|null
     */
    public function getDynamicEmailSubject()
    {
        return $this->DynamicEmailSubject;
    }
    /**
     * Set DynamicEmailSubject value
     * @param string $dynamicEmailSubject
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setDynamicEmailSubject($dynamicEmailSubject = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicEmailSubject) && !is_string($dynamicEmailSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dynamicEmailSubject)), __LINE__);
        }
        $this->DynamicEmailSubject = $dynamicEmailSubject;
        return $this;
    }
    /**
     * Get IsMultipart value
     * @return bool|null
     */
    public function getIsMultipart()
    {
        return $this->IsMultipart;
    }
    /**
     * Set IsMultipart value
     * @param bool $isMultipart
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setIsMultipart($isMultipart = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMultipart) && !is_bool($isMultipart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isMultipart)), __LINE__);
        }
        $this->IsMultipart = $isMultipart;
        return $this;
    }
    /**
     * Get IsWrapped value
     * @return bool|null
     */
    public function getIsWrapped()
    {
        return $this->IsWrapped;
    }
    /**
     * Set IsWrapped value
     * @param bool $isWrapped
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setIsWrapped($isWrapped = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWrapped) && !is_bool($isWrapped)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isWrapped)), __LINE__);
        }
        $this->IsWrapped = $isWrapped;
        return $this;
    }
    /**
     * Get AllowedSlots value
     * @return int|null
     */
    public function getAllowedSlots()
    {
        return $this->AllowedSlots;
    }
    /**
     * Set AllowedSlots value
     * @param int $allowedSlots
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setAllowedSlots($allowedSlots = null)
    {
        // validation for constraint: int
        if (!is_null($allowedSlots) && !is_numeric($allowedSlots)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($allowedSlots)), __LINE__);
        }
        $this->AllowedSlots = $allowedSlots;
        return $this;
    }
    /**
     * Get NewSlotTrigger value
     * @return int|null
     */
    public function getNewSlotTrigger()
    {
        return $this->NewSlotTrigger;
    }
    /**
     * Set NewSlotTrigger value
     * @param int $newSlotTrigger
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setNewSlotTrigger($newSlotTrigger = null)
    {
        // validation for constraint: int
        if (!is_null($newSlotTrigger) && !is_numeric($newSlotTrigger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($newSlotTrigger)), __LINE__);
        }
        $this->NewSlotTrigger = $newSlotTrigger;
        return $this;
    }
    /**
     * Get SendLimit value
     * @return int|null
     */
    public function getSendLimit()
    {
        return $this->SendLimit;
    }
    /**
     * Set SendLimit value
     * @param int $sendLimit
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setSendLimit($sendLimit = null)
    {
        // validation for constraint: int
        if (!is_null($sendLimit) && !is_numeric($sendLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sendLimit)), __LINE__);
        }
        $this->SendLimit = $sendLimit;
        return $this;
    }
    /**
     * Get SendWindowOpen value
     * @return string|null
     */
    public function getSendWindowOpen()
    {
        return $this->SendWindowOpen;
    }
    /**
     * Set SendWindowOpen value
     * @param string $sendWindowOpen
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setSendWindowOpen($sendWindowOpen = null)
    {
        // validation for constraint: string
        if (!is_null($sendWindowOpen) && !is_string($sendWindowOpen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendWindowOpen)), __LINE__);
        }
        $this->SendWindowOpen = $sendWindowOpen;
        return $this;
    }
    /**
     * Get SendWindowClose value
     * @return string|null
     */
    public function getSendWindowClose()
    {
        return $this->SendWindowClose;
    }
    /**
     * Set SendWindowClose value
     * @param string $sendWindowClose
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setSendWindowClose($sendWindowClose = null)
    {
        // validation for constraint: string
        if (!is_null($sendWindowClose) && !is_string($sendWindowClose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendWindowClose)), __LINE__);
        }
        $this->SendWindowClose = $sendWindowClose;
        return $this;
    }
    /**
     * Get SendWindowDelete value
     * @return bool|null
     */
    public function getSendWindowDelete()
    {
        return $this->SendWindowDelete;
    }
    /**
     * Set SendWindowDelete value
     * @param bool $sendWindowDelete
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setSendWindowDelete($sendWindowDelete = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendWindowDelete) && !is_bool($sendWindowDelete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendWindowDelete)), __LINE__);
        }
        $this->SendWindowDelete = $sendWindowDelete;
        return $this;
    }
    /**
     * Get RefreshContent value
     * @return bool|null
     */
    public function getRefreshContent()
    {
        return $this->RefreshContent;
    }
    /**
     * Set RefreshContent value
     * @param bool $refreshContent
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setRefreshContent($refreshContent = null)
    {
        // validation for constraint: boolean
        if (!is_null($refreshContent) && !is_bool($refreshContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($refreshContent)), __LINE__);
        }
        $this->RefreshContent = $refreshContent;
        return $this;
    }
    /**
     * Get ExclusionFilter value
     * @return string|null
     */
    public function getExclusionFilter()
    {
        return $this->ExclusionFilter;
    }
    /**
     * Set ExclusionFilter value
     * @param string $exclusionFilter
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setExclusionFilter($exclusionFilter = null)
    {
        // validation for constraint: string
        if (!is_null($exclusionFilter) && !is_string($exclusionFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exclusionFilter)), __LINE__);
        }
        $this->ExclusionFilter = $exclusionFilter;
        return $this;
    }
    /**
     * Get Priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param string $priority
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: string
        if (!is_null($priority) && !is_string($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get SendSourceCustomerKey value
     * @return string|null
     */
    public function getSendSourceCustomerKey()
    {
        return $this->SendSourceCustomerKey;
    }
    /**
     * Set SendSourceCustomerKey value
     * @param string $sendSourceCustomerKey
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setSendSourceCustomerKey($sendSourceCustomerKey = null)
    {
        // validation for constraint: string
        if (!is_null($sendSourceCustomerKey) && !is_string($sendSourceCustomerKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendSourceCustomerKey)), __LINE__);
        }
        $this->SendSourceCustomerKey = $sendSourceCustomerKey;
        return $this;
    }
    /**
     * Get ExclusionListCollection value
     * @return \App\Library\ExactTarget\StructType\TriggeredSendExclusionList[]|null
     */
    public function getExclusionListCollection()
    {
        return $this->ExclusionListCollection;
    }
    /**
     * Set ExclusionListCollection value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\TriggeredSendExclusionList[] $exclusionListCollection
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setExclusionListCollection(array $exclusionListCollection = array())
    {
        foreach ($exclusionListCollection as $triggeredSendDefinitionExclusionListCollectionItem) {
            // validation for constraint: itemType
            if (!$triggeredSendDefinitionExclusionListCollectionItem instanceof \App\Library\ExactTarget\StructType\TriggeredSendExclusionList) {
                throw new \InvalidArgumentException(sprintf('The ExclusionListCollection property can only contain items of \App\Library\ExactTarget\StructType\TriggeredSendExclusionList, "%s" given', is_object($triggeredSendDefinitionExclusionListCollectionItem) ? get_class($triggeredSendDefinitionExclusionListCollectionItem) : gettype($triggeredSendDefinitionExclusionListCollectionItem)), __LINE__);
            }
        }
        $this->ExclusionListCollection = $exclusionListCollection;
        return $this;
    }
    /**
     * Add item to ExclusionListCollection value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\TriggeredSendExclusionList $item
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function addToExclusionListCollection(\App\Library\ExactTarget\StructType\TriggeredSendExclusionList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\TriggeredSendExclusionList) {
            throw new \InvalidArgumentException(sprintf('The ExclusionListCollection property can only contain items of \App\Library\ExactTarget\StructType\TriggeredSendExclusionList, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExclusionListCollection[] = $item;
        return $this;
    }
    /**
     * Get CCEmail value
     * @return string|null
     */
    public function getCCEmail()
    {
        return $this->CCEmail;
    }
    /**
     * Set CCEmail value
     * @param string $cCEmail
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setCCEmail($cCEmail = null)
    {
        // validation for constraint: string
        if (!is_null($cCEmail) && !is_string($cCEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cCEmail)), __LINE__);
        }
        $this->CCEmail = $cCEmail;
        return $this;
    }
    /**
     * Get SendSourceDataExtension value
     * @return \App\Library\ExactTarget\StructType\DataExtension|null
     */
    public function getSendSourceDataExtension()
    {
        return $this->SendSourceDataExtension;
    }
    /**
     * Set SendSourceDataExtension value
     * @param \App\Library\ExactTarget\StructType\DataExtension $sendSourceDataExtension
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setSendSourceDataExtension(\App\Library\ExactTarget\StructType\DataExtension $sendSourceDataExtension = null)
    {
        $this->SendSourceDataExtension = $sendSourceDataExtension;
        return $this;
    }
    /**
     * Get IsAlwaysOn value
     * @return bool|null
     */
    public function getIsAlwaysOn()
    {
        return $this->IsAlwaysOn;
    }
    /**
     * Set IsAlwaysOn value
     * @param bool $isAlwaysOn
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setIsAlwaysOn($isAlwaysOn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlwaysOn) && !is_bool($isAlwaysOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAlwaysOn)), __LINE__);
        }
        $this->IsAlwaysOn = $isAlwaysOn;
        return $this;
    }
    /**
     * Get DisableOnEmailBuildError value
     * @return bool|null
     */
    public function getDisableOnEmailBuildError()
    {
        return $this->DisableOnEmailBuildError;
    }
    /**
     * Set DisableOnEmailBuildError value
     * @param bool $disableOnEmailBuildError
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setDisableOnEmailBuildError($disableOnEmailBuildError = null)
    {
        // validation for constraint: boolean
        if (!is_null($disableOnEmailBuildError) && !is_bool($disableOnEmailBuildError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($disableOnEmailBuildError)), __LINE__);
        }
        $this->DisableOnEmailBuildError = $disableOnEmailBuildError;
        return $this;
    }
    /**
     * Get PreHeader value
     * @return string|null
     */
    public function getPreHeader()
    {
        return $this->PreHeader;
    }
    /**
     * Set PreHeader value
     * @param string $preHeader
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setPreHeader($preHeader = null)
    {
        // validation for constraint: string
        if (!is_null($preHeader) && !is_string($preHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($preHeader)), __LINE__);
        }
        $this->PreHeader = $preHeader;
        return $this;
    }
    /**
     * Get ReplyToAddress value
     * @return string|null
     */
    public function getReplyToAddress()
    {
        return $this->ReplyToAddress;
    }
    /**
     * Set ReplyToAddress value
     * @param string $replyToAddress
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setReplyToAddress($replyToAddress = null)
    {
        // validation for constraint: string
        if (!is_null($replyToAddress) && !is_string($replyToAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($replyToAddress)), __LINE__);
        }
        $this->ReplyToAddress = $replyToAddress;
        return $this;
    }
    /**
     * Get ReplyToDisplayName value
     * @return string|null
     */
    public function getReplyToDisplayName()
    {
        return $this->ReplyToDisplayName;
    }
    /**
     * Set ReplyToDisplayName value
     * @param string $replyToDisplayName
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setReplyToDisplayName($replyToDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($replyToDisplayName) && !is_string($replyToDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($replyToDisplayName)), __LINE__);
        }
        $this->ReplyToDisplayName = $replyToDisplayName;
        return $this;
    }
    /**
     * Get TriggeredSendClass value
     * @return string|null
     */
    public function getTriggeredSendClass()
    {
        return $this->TriggeredSendClass;
    }
    /**
     * Set TriggeredSendClass value
     * @uses \App\Library\ExactTarget\EnumType\TriggeredSendClassEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\TriggeredSendClassEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $triggeredSendClass
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setTriggeredSendClass($triggeredSendClass = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\TriggeredSendClassEnum::valueIsValid($triggeredSendClass)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $triggeredSendClass, implode(', ', \App\Library\ExactTarget\EnumType\TriggeredSendClassEnum::getValidValues())), __LINE__);
        }
        $this->TriggeredSendClass = $triggeredSendClass;
        return $this;
    }
    /**
     * Get TriggeredSendSubClass value
     * @return string|null
     */
    public function getTriggeredSendSubClass()
    {
        return $this->TriggeredSendSubClass;
    }
    /**
     * Set TriggeredSendSubClass value
     * @uses \App\Library\ExactTarget\EnumType\TriggeredSendSubClassEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\TriggeredSendSubClassEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $triggeredSendSubClass
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public function setTriggeredSendSubClass($triggeredSendSubClass = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\TriggeredSendSubClassEnum::valueIsValid($triggeredSendSubClass)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $triggeredSendSubClass, implode(', ', \App\Library\ExactTarget\EnumType\TriggeredSendSubClassEnum::getValidValues())), __LINE__);
        }
        $this->TriggeredSendSubClass = $triggeredSendSubClass;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\TriggeredSendDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
