<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingUser StructType
 * @subpackage Structs
 */
class TrackingUser extends APIObject
{
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The EmployeeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $EmployeeID;
    /**
     * Constructor method for TrackingUser
     * @uses TrackingUser::setIsActive()
     * @uses TrackingUser::setEmployeeID()
     * @param bool $isActive
     * @param int $employeeID
     */
    public function __construct($isActive = null, $employeeID = null)
    {
        $this
            ->setIsActive($isActive)
            ->setEmployeeID($employeeID);
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \App\Library\ExactTarget\StructType\TrackingUser
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get EmployeeID value
     * @return int|null
     */
    public function getEmployeeID()
    {
        return $this->EmployeeID;
    }
    /**
     * Set EmployeeID value
     * @param int $employeeID
     * @return \App\Library\ExactTarget\StructType\TrackingUser
     */
    public function setEmployeeID($employeeID = null)
    {
        // validation for constraint: int
        if (!is_null($employeeID) && !is_numeric($employeeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($employeeID)), __LINE__);
        }
        $this->EmployeeID = $employeeID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\TrackingUser
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
