<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingEvent StructType
 * @subpackage Structs
 */
class TrackingEvent extends APIObject
{
    /**
     * The SendID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SendID;
    /**
     * The SubscriberKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubscriberKey;
    /**
     * The EventDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventDate;
    /**
     * The EventType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventType;
    /**
     * The TriggeredSendDefinitionObjectID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TriggeredSendDefinitionObjectID;
    /**
     * The BatchID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $BatchID;
    /**
     * Constructor method for TrackingEvent
     * @uses TrackingEvent::setSendID()
     * @uses TrackingEvent::setSubscriberKey()
     * @uses TrackingEvent::setEventDate()
     * @uses TrackingEvent::setEventType()
     * @uses TrackingEvent::setTriggeredSendDefinitionObjectID()
     * @uses TrackingEvent::setBatchID()
     * @param int $sendID
     * @param string $subscriberKey
     * @param string $eventDate
     * @param string $eventType
     * @param string $triggeredSendDefinitionObjectID
     * @param int $batchID
     */
    public function __construct($sendID = null, $subscriberKey = null, $eventDate = null, $eventType = null, $triggeredSendDefinitionObjectID = null, $batchID = null)
    {
        $this
            ->setSendID($sendID)
            ->setSubscriberKey($subscriberKey)
            ->setEventDate($eventDate)
            ->setEventType($eventType)
            ->setTriggeredSendDefinitionObjectID($triggeredSendDefinitionObjectID)
            ->setBatchID($batchID);
    }
    /**
     * Get SendID value
     * @return int|null
     */
    public function getSendID()
    {
        return $this->SendID;
    }
    /**
     * Set SendID value
     * @param int $sendID
     * @return \App\Library\ExactTarget\StructType\TrackingEvent
     */
    public function setSendID($sendID = null)
    {
        // validation for constraint: int
        if (!is_null($sendID) && !is_numeric($sendID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sendID)), __LINE__);
        }
        $this->SendID = $sendID;
        return $this;
    }
    /**
     * Get SubscriberKey value
     * @return string|null
     */
    public function getSubscriberKey()
    {
        return $this->SubscriberKey;
    }
    /**
     * Set SubscriberKey value
     * @param string $subscriberKey
     * @return \App\Library\ExactTarget\StructType\TrackingEvent
     */
    public function setSubscriberKey($subscriberKey = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberKey) && !is_string($subscriberKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberKey)), __LINE__);
        }
        $this->SubscriberKey = $subscriberKey;
        return $this;
    }
    /**
     * Get EventDate value
     * @return string|null
     */
    public function getEventDate()
    {
        return $this->EventDate;
    }
    /**
     * Set EventDate value
     * @param string $eventDate
     * @return \App\Library\ExactTarget\StructType\TrackingEvent
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventDate)), __LINE__);
        }
        $this->EventDate = $eventDate;
        return $this;
    }
    /**
     * Get EventType value
     * @return string|null
     */
    public function getEventType()
    {
        return $this->EventType;
    }
    /**
     * Set EventType value
     * @uses \App\Library\ExactTarget\EnumType\EventType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\EventType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventType
     * @return \App\Library\ExactTarget\StructType\TrackingEvent
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\EventType::valueIsValid($eventType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $eventType, implode(', ', \App\Library\ExactTarget\EnumType\EventType::getValidValues())), __LINE__);
        }
        $this->EventType = $eventType;
        return $this;
    }
    /**
     * Get TriggeredSendDefinitionObjectID value
     * @return string|null
     */
    public function getTriggeredSendDefinitionObjectID()
    {
        return $this->TriggeredSendDefinitionObjectID;
    }
    /**
     * Set TriggeredSendDefinitionObjectID value
     * @param string $triggeredSendDefinitionObjectID
     * @return \App\Library\ExactTarget\StructType\TrackingEvent
     */
    public function setTriggeredSendDefinitionObjectID($triggeredSendDefinitionObjectID = null)
    {
        // validation for constraint: string
        if (!is_null($triggeredSendDefinitionObjectID) && !is_string($triggeredSendDefinitionObjectID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($triggeredSendDefinitionObjectID)), __LINE__);
        }
        $this->TriggeredSendDefinitionObjectID = $triggeredSendDefinitionObjectID;
        return $this;
    }
    /**
     * Get BatchID value
     * @return int|null
     */
    public function getBatchID()
    {
        return $this->BatchID;
    }
    /**
     * Set BatchID value
     * @param int $batchID
     * @return \App\Library\ExactTarget\StructType\TrackingEvent
     */
    public function setBatchID($batchID = null)
    {
        // validation for constraint: int
        if (!is_null($batchID) && !is_numeric($batchID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($batchID)), __LINE__);
        }
        $this->BatchID = $batchID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\TrackingEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
