<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaskResult StructType
 * @subpackage Structs
 */
class TaskResult extends AbstractStructBase
{
    /**
     * The StatusCode
     * @var string
     */
    public $StatusCode;
    /**
     * The StatusMessage
     * @var string
     */
    public $StatusMessage;
    /**
     * The OrdinalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OrdinalID;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The TblAsyncID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TblAsyncID;
    /**
     * The InteractionObjectID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InteractionObjectID;
    /**
     * Constructor method for TaskResult
     * @uses TaskResult::setStatusCode()
     * @uses TaskResult::setStatusMessage()
     * @uses TaskResult::setOrdinalID()
     * @uses TaskResult::setErrorCode()
     * @uses TaskResult::setID()
     * @uses TaskResult::setTblAsyncID()
     * @uses TaskResult::setInteractionObjectID()
     * @param string $statusCode
     * @param string $statusMessage
     * @param int $ordinalID
     * @param int $errorCode
     * @param string $iD
     * @param int $tblAsyncID
     * @param string $interactionObjectID
     */
    public function __construct($statusCode = null, $statusMessage = null, $ordinalID = null, $errorCode = null, $iD = null, $tblAsyncID = null, $interactionObjectID = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setStatusMessage($statusMessage)
            ->setOrdinalID($ordinalID)
            ->setErrorCode($errorCode)
            ->setID($iD)
            ->setTblAsyncID($tblAsyncID)
            ->setInteractionObjectID($interactionObjectID);
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \App\Library\ExactTarget\StructType\TaskResult
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get StatusMessage value
     * @return string|null
     */
    public function getStatusMessage()
    {
        return $this->StatusMessage;
    }
    /**
     * Set StatusMessage value
     * @param string $statusMessage
     * @return \App\Library\ExactTarget\StructType\TaskResult
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusMessage)), __LINE__);
        }
        $this->StatusMessage = $statusMessage;
        return $this;
    }
    /**
     * Get OrdinalID value
     * @return int|null
     */
    public function getOrdinalID()
    {
        return $this->OrdinalID;
    }
    /**
     * Set OrdinalID value
     * @param int $ordinalID
     * @return \App\Library\ExactTarget\StructType\TaskResult
     */
    public function setOrdinalID($ordinalID = null)
    {
        // validation for constraint: int
        if (!is_null($ordinalID) && !is_numeric($ordinalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ordinalID)), __LINE__);
        }
        $this->OrdinalID = $ordinalID;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \App\Library\ExactTarget\StructType\TaskResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \App\Library\ExactTarget\StructType\TaskResult
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get TblAsyncID value
     * @return int|null
     */
    public function getTblAsyncID()
    {
        return $this->TblAsyncID;
    }
    /**
     * Set TblAsyncID value
     * @param int $tblAsyncID
     * @return \App\Library\ExactTarget\StructType\TaskResult
     */
    public function setTblAsyncID($tblAsyncID = null)
    {
        // validation for constraint: int
        if (!is_null($tblAsyncID) && !is_numeric($tblAsyncID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tblAsyncID)), __LINE__);
        }
        $this->TblAsyncID = $tblAsyncID;
        return $this;
    }
    /**
     * Get InteractionObjectID value
     * @return string|null
     */
    public function getInteractionObjectID()
    {
        return $this->InteractionObjectID;
    }
    /**
     * Set InteractionObjectID value
     * @param string $interactionObjectID
     * @return \App\Library\ExactTarget\StructType\TaskResult
     */
    public function setInteractionObjectID($interactionObjectID = null)
    {
        // validation for constraint: string
        if (!is_null($interactionObjectID) && !is_string($interactionObjectID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($interactionObjectID)), __LINE__);
        }
        $this->InteractionObjectID = $interactionObjectID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\TaskResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
