<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemStatusResult StructType
 * @subpackage Structs
 */
class SystemStatusResult extends Result
{
    /**
     * The SystemStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SystemStatus;
    /**
     * The Outages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Outages
     */
    public $Outages;
    /**
     * Constructor method for SystemStatusResult
     * @uses SystemStatusResult::setSystemStatus()
     * @uses SystemStatusResult::setOutages()
     * @param string $systemStatus
     * @param \App\Library\ExactTarget\StructType\Outages $outages
     */
    public function __construct($systemStatus = null, \App\Library\ExactTarget\StructType\Outages $outages = null)
    {
        $this
            ->setSystemStatus($systemStatus)
            ->setOutages($outages);
    }
    /**
     * Get SystemStatus value
     * @return string
     */
    public function getSystemStatus()
    {
        return $this->SystemStatus;
    }
    /**
     * Set SystemStatus value
     * @uses \App\Library\ExactTarget\EnumType\SystemStatusType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SystemStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $systemStatus
     * @return \App\Library\ExactTarget\StructType\SystemStatusResult
     */
    public function setSystemStatus($systemStatus = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SystemStatusType::valueIsValid($systemStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $systemStatus, implode(', ', \App\Library\ExactTarget\EnumType\SystemStatusType::getValidValues())), __LINE__);
        }
        $this->SystemStatus = $systemStatus;
        return $this;
    }
    /**
     * Get Outages value
     * @return \App\Library\ExactTarget\StructType\Outages|null
     */
    public function getOutages()
    {
        return $this->Outages;
    }
    /**
     * Set Outages value
     * @param \App\Library\ExactTarget\StructType\Outages $outages
     * @return \App\Library\ExactTarget\StructType\SystemStatusResult
     */
    public function setOutages(\App\Library\ExactTarget\StructType\Outages $outages = null)
    {
        $this->Outages = $outages;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SystemStatusResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
