<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SurveyEvent StructType
 * @subpackage Structs
 */
class SurveyEvent extends TrackingEvent
{
    /**
     * The Question
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Question;
    /**
     * The Answer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Answer;
    /**
     * Constructor method for SurveyEvent
     * @uses SurveyEvent::setQuestion()
     * @uses SurveyEvent::setAnswer()
     * @param string $question
     * @param string $answer
     */
    public function __construct($question = null, $answer = null)
    {
        $this
            ->setQuestion($question)
            ->setAnswer($answer);
    }
    /**
     * Get Question value
     * @return string|null
     */
    public function getQuestion()
    {
        return $this->Question;
    }
    /**
     * Set Question value
     * @param string $question
     * @return \App\Library\ExactTarget\StructType\SurveyEvent
     */
    public function setQuestion($question = null)
    {
        // validation for constraint: string
        if (!is_null($question) && !is_string($question)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($question)), __LINE__);
        }
        $this->Question = $question;
        return $this;
    }
    /**
     * Get Answer value
     * @return string|null
     */
    public function getAnswer()
    {
        return $this->Answer;
    }
    /**
     * Set Answer value
     * @param string $answer
     * @return \App\Library\ExactTarget\StructType\SurveyEvent
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: string
        if (!is_null($answer) && !is_string($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($answer)), __LINE__);
        }
        $this->Answer = $answer;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SurveyEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
