<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuppressionLists StructType
 * @subpackage Structs
 */
class SuppressionLists extends AbstractStructBase
{
    /**
     * The SuppressionList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AudienceItem[]
     */
    public $SuppressionList;
    /**
     * Constructor method for SuppressionLists
     * @uses SuppressionLists::setSuppressionList()
     * @param \App\Library\ExactTarget\StructType\AudienceItem[] $suppressionList
     */
    public function __construct(array $suppressionList = array())
    {
        $this
            ->setSuppressionList($suppressionList);
    }
    /**
     * Get SuppressionList value
     * @return \App\Library\ExactTarget\StructType\AudienceItem[]|null
     */
    public function getSuppressionList()
    {
        return $this->SuppressionList;
    }
    /**
     * Set SuppressionList value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AudienceItem[] $suppressionList
     * @return \App\Library\ExactTarget\StructType\SuppressionLists
     */
    public function setSuppressionList(array $suppressionList = array())
    {
        foreach ($suppressionList as $suppressionListsSuppressionListItem) {
            // validation for constraint: itemType
            if (!$suppressionListsSuppressionListItem instanceof \App\Library\ExactTarget\StructType\AudienceItem) {
                throw new \InvalidArgumentException(sprintf('The SuppressionList property can only contain items of \App\Library\ExactTarget\StructType\AudienceItem, "%s" given', is_object($suppressionListsSuppressionListItem) ? get_class($suppressionListsSuppressionListItem) : gettype($suppressionListsSuppressionListItem)), __LINE__);
            }
        }
        $this->SuppressionList = $suppressionList;
        return $this;
    }
    /**
     * Add item to SuppressionList value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AudienceItem $item
     * @return \App\Library\ExactTarget\StructType\SuppressionLists
     */
    public function addToSuppressionList(\App\Library\ExactTarget\StructType\AudienceItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AudienceItem) {
            throw new \InvalidArgumentException(sprintf('The SuppressionList property can only contain items of \App\Library\ExactTarget\StructType\AudienceItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SuppressionList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SuppressionLists
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
