<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subscription StructType
 * @subpackage Structs
 */
class Subscription extends AbstractStructBase
{
    /**
     * The EmailsPurchased
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EmailsPurchased;
    /**
     * The AccountsPurchased
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountsPurchased;
    /**
     * The AdvAccountsPurchased
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AdvAccountsPurchased;
    /**
     * The LPAccountsPurchased
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LPAccountsPurchased;
    /**
     * The DOTOAccountsPurchased
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DOTOAccountsPurchased;
    /**
     * The BUAccountsPurchased
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BUAccountsPurchased;
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndDate;
    /**
     * The Period
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Period;
    /**
     * The HasPurchasedEmails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HasPurchasedEmails;
    /**
     * The NumberofEmails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumberofEmails;
    /**
     * The SubscriptionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SubscriptionID;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The NotificationTitle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotificationTitle;
    /**
     * The NotificationMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotificationMessage;
    /**
     * The NotificationFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotificationFlag;
    /**
     * The NotificationExpDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotificationExpDate;
    /**
     * The ForAccounting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ForAccounting;
    /**
     * The ContractNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractNumber;
    /**
     * The ContractModifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractModifier;
    /**
     * The IsRenewal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsRenewal;
    /**
     * Constructor method for Subscription
     * @uses Subscription::setEmailsPurchased()
     * @uses Subscription::setAccountsPurchased()
     * @uses Subscription::setAdvAccountsPurchased()
     * @uses Subscription::setLPAccountsPurchased()
     * @uses Subscription::setDOTOAccountsPurchased()
     * @uses Subscription::setBUAccountsPurchased()
     * @uses Subscription::setBeginDate()
     * @uses Subscription::setEndDate()
     * @uses Subscription::setPeriod()
     * @uses Subscription::setHasPurchasedEmails()
     * @uses Subscription::setNumberofEmails()
     * @uses Subscription::setSubscriptionID()
     * @uses Subscription::setNotes()
     * @uses Subscription::setNotificationTitle()
     * @uses Subscription::setNotificationMessage()
     * @uses Subscription::setNotificationFlag()
     * @uses Subscription::setNotificationExpDate()
     * @uses Subscription::setForAccounting()
     * @uses Subscription::setContractNumber()
     * @uses Subscription::setContractModifier()
     * @uses Subscription::setIsRenewal()
     * @param int $emailsPurchased
     * @param int $accountsPurchased
     * @param int $advAccountsPurchased
     * @param int $lPAccountsPurchased
     * @param int $dOTOAccountsPurchased
     * @param int $bUAccountsPurchased
     * @param string $beginDate
     * @param string $endDate
     * @param string $period
     * @param bool $hasPurchasedEmails
     * @param int $numberofEmails
     * @param int $subscriptionID
     * @param string $notes
     * @param string $notificationTitle
     * @param string $notificationMessage
     * @param string $notificationFlag
     * @param string $notificationExpDate
     * @param string $forAccounting
     * @param string $contractNumber
     * @param string $contractModifier
     * @param bool $isRenewal
     */
    public function __construct($emailsPurchased = null, $accountsPurchased = null, $advAccountsPurchased = null, $lPAccountsPurchased = null, $dOTOAccountsPurchased = null, $bUAccountsPurchased = null, $beginDate = null, $endDate = null, $period = null, $hasPurchasedEmails = null, $numberofEmails = null, $subscriptionID = null, $notes = null, $notificationTitle = null, $notificationMessage = null, $notificationFlag = null, $notificationExpDate = null, $forAccounting = null, $contractNumber = null, $contractModifier = null, $isRenewal = null)
    {
        $this
            ->setEmailsPurchased($emailsPurchased)
            ->setAccountsPurchased($accountsPurchased)
            ->setAdvAccountsPurchased($advAccountsPurchased)
            ->setLPAccountsPurchased($lPAccountsPurchased)
            ->setDOTOAccountsPurchased($dOTOAccountsPurchased)
            ->setBUAccountsPurchased($bUAccountsPurchased)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setPeriod($period)
            ->setHasPurchasedEmails($hasPurchasedEmails)
            ->setNumberofEmails($numberofEmails)
            ->setSubscriptionID($subscriptionID)
            ->setNotes($notes)
            ->setNotificationTitle($notificationTitle)
            ->setNotificationMessage($notificationMessage)
            ->setNotificationFlag($notificationFlag)
            ->setNotificationExpDate($notificationExpDate)
            ->setForAccounting($forAccounting)
            ->setContractNumber($contractNumber)
            ->setContractModifier($contractModifier)
            ->setIsRenewal($isRenewal);
    }
    /**
     * Get EmailsPurchased value
     * @return int
     */
    public function getEmailsPurchased()
    {
        return $this->EmailsPurchased;
    }
    /**
     * Set EmailsPurchased value
     * @param int $emailsPurchased
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setEmailsPurchased($emailsPurchased = null)
    {
        // validation for constraint: int
        if (!is_null($emailsPurchased) && !is_numeric($emailsPurchased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($emailsPurchased)), __LINE__);
        }
        $this->EmailsPurchased = $emailsPurchased;
        return $this;
    }
    /**
     * Get AccountsPurchased value
     * @return int
     */
    public function getAccountsPurchased()
    {
        return $this->AccountsPurchased;
    }
    /**
     * Set AccountsPurchased value
     * @param int $accountsPurchased
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setAccountsPurchased($accountsPurchased = null)
    {
        // validation for constraint: int
        if (!is_null($accountsPurchased) && !is_numeric($accountsPurchased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountsPurchased)), __LINE__);
        }
        $this->AccountsPurchased = $accountsPurchased;
        return $this;
    }
    /**
     * Get AdvAccountsPurchased value
     * @return int
     */
    public function getAdvAccountsPurchased()
    {
        return $this->AdvAccountsPurchased;
    }
    /**
     * Set AdvAccountsPurchased value
     * @param int $advAccountsPurchased
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setAdvAccountsPurchased($advAccountsPurchased = null)
    {
        // validation for constraint: int
        if (!is_null($advAccountsPurchased) && !is_numeric($advAccountsPurchased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($advAccountsPurchased)), __LINE__);
        }
        $this->AdvAccountsPurchased = $advAccountsPurchased;
        return $this;
    }
    /**
     * Get LPAccountsPurchased value
     * @return int
     */
    public function getLPAccountsPurchased()
    {
        return $this->LPAccountsPurchased;
    }
    /**
     * Set LPAccountsPurchased value
     * @param int $lPAccountsPurchased
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setLPAccountsPurchased($lPAccountsPurchased = null)
    {
        // validation for constraint: int
        if (!is_null($lPAccountsPurchased) && !is_numeric($lPAccountsPurchased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lPAccountsPurchased)), __LINE__);
        }
        $this->LPAccountsPurchased = $lPAccountsPurchased;
        return $this;
    }
    /**
     * Get DOTOAccountsPurchased value
     * @return int
     */
    public function getDOTOAccountsPurchased()
    {
        return $this->DOTOAccountsPurchased;
    }
    /**
     * Set DOTOAccountsPurchased value
     * @param int $dOTOAccountsPurchased
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setDOTOAccountsPurchased($dOTOAccountsPurchased = null)
    {
        // validation for constraint: int
        if (!is_null($dOTOAccountsPurchased) && !is_numeric($dOTOAccountsPurchased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dOTOAccountsPurchased)), __LINE__);
        }
        $this->DOTOAccountsPurchased = $dOTOAccountsPurchased;
        return $this;
    }
    /**
     * Get BUAccountsPurchased value
     * @return int
     */
    public function getBUAccountsPurchased()
    {
        return $this->BUAccountsPurchased;
    }
    /**
     * Set BUAccountsPurchased value
     * @param int $bUAccountsPurchased
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setBUAccountsPurchased($bUAccountsPurchased = null)
    {
        // validation for constraint: int
        if (!is_null($bUAccountsPurchased) && !is_numeric($bUAccountsPurchased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($bUAccountsPurchased)), __LINE__);
        }
        $this->BUAccountsPurchased = $bUAccountsPurchased;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get Period value
     * @return string
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param string $period
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setPeriod($period = null)
    {
        // validation for constraint: string
        if (!is_null($period) && !is_string($period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($period)), __LINE__);
        }
        $this->Period = $period;
        return $this;
    }
    /**
     * Get HasPurchasedEmails value
     * @return bool
     */
    public function getHasPurchasedEmails()
    {
        return $this->HasPurchasedEmails;
    }
    /**
     * Set HasPurchasedEmails value
     * @param bool $hasPurchasedEmails
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setHasPurchasedEmails($hasPurchasedEmails = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasPurchasedEmails) && !is_bool($hasPurchasedEmails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasPurchasedEmails)), __LINE__);
        }
        $this->HasPurchasedEmails = $hasPurchasedEmails;
        return $this;
    }
    /**
     * Get NumberofEmails value
     * @return int
     */
    public function getNumberofEmails()
    {
        return $this->NumberofEmails;
    }
    /**
     * Set NumberofEmails value
     * @param int $numberofEmails
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setNumberofEmails($numberofEmails = null)
    {
        // validation for constraint: int
        if (!is_null($numberofEmails) && !is_numeric($numberofEmails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberofEmails)), __LINE__);
        }
        $this->NumberofEmails = $numberofEmails;
        return $this;
    }
    /**
     * Get SubscriptionID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSubscriptionID()
    {
        return isset($this->SubscriptionID) ? $this->SubscriptionID : null;
    }
    /**
     * Set SubscriptionID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $subscriptionID
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setSubscriptionID($subscriptionID = null)
    {
        // validation for constraint: int
        if (!is_null($subscriptionID) && !is_numeric($subscriptionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($subscriptionID)), __LINE__);
        }
        if (is_null($subscriptionID) || (is_array($subscriptionID) && empty($subscriptionID))) {
            unset($this->SubscriptionID);
        } else {
            $this->SubscriptionID = $subscriptionID;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get NotificationTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotificationTitle()
    {
        return isset($this->NotificationTitle) ? $this->NotificationTitle : null;
    }
    /**
     * Set NotificationTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notificationTitle
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setNotificationTitle($notificationTitle = null)
    {
        // validation for constraint: string
        if (!is_null($notificationTitle) && !is_string($notificationTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationTitle)), __LINE__);
        }
        if (is_null($notificationTitle) || (is_array($notificationTitle) && empty($notificationTitle))) {
            unset($this->NotificationTitle);
        } else {
            $this->NotificationTitle = $notificationTitle;
        }
        return $this;
    }
    /**
     * Get NotificationMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotificationMessage()
    {
        return isset($this->NotificationMessage) ? $this->NotificationMessage : null;
    }
    /**
     * Set NotificationMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notificationMessage
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setNotificationMessage($notificationMessage = null)
    {
        // validation for constraint: string
        if (!is_null($notificationMessage) && !is_string($notificationMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationMessage)), __LINE__);
        }
        if (is_null($notificationMessage) || (is_array($notificationMessage) && empty($notificationMessage))) {
            unset($this->NotificationMessage);
        } else {
            $this->NotificationMessage = $notificationMessage;
        }
        return $this;
    }
    /**
     * Get NotificationFlag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotificationFlag()
    {
        return isset($this->NotificationFlag) ? $this->NotificationFlag : null;
    }
    /**
     * Set NotificationFlag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notificationFlag
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setNotificationFlag($notificationFlag = null)
    {
        // validation for constraint: string
        if (!is_null($notificationFlag) && !is_string($notificationFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationFlag)), __LINE__);
        }
        if (is_null($notificationFlag) || (is_array($notificationFlag) && empty($notificationFlag))) {
            unset($this->NotificationFlag);
        } else {
            $this->NotificationFlag = $notificationFlag;
        }
        return $this;
    }
    /**
     * Get NotificationExpDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotificationExpDate()
    {
        return isset($this->NotificationExpDate) ? $this->NotificationExpDate : null;
    }
    /**
     * Set NotificationExpDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notificationExpDate
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setNotificationExpDate($notificationExpDate = null)
    {
        // validation for constraint: string
        if (!is_null($notificationExpDate) && !is_string($notificationExpDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notificationExpDate)), __LINE__);
        }
        if (is_null($notificationExpDate) || (is_array($notificationExpDate) && empty($notificationExpDate))) {
            unset($this->NotificationExpDate);
        } else {
            $this->NotificationExpDate = $notificationExpDate;
        }
        return $this;
    }
    /**
     * Get ForAccounting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForAccounting()
    {
        return isset($this->ForAccounting) ? $this->ForAccounting : null;
    }
    /**
     * Set ForAccounting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forAccounting
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setForAccounting($forAccounting = null)
    {
        // validation for constraint: string
        if (!is_null($forAccounting) && !is_string($forAccounting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forAccounting)), __LINE__);
        }
        if (is_null($forAccounting) || (is_array($forAccounting) && empty($forAccounting))) {
            unset($this->ForAccounting);
        } else {
            $this->ForAccounting = $forAccounting;
        }
        return $this;
    }
    /**
     * Get ContractNumber value
     * @return string|null
     */
    public function getContractNumber()
    {
        return $this->ContractNumber;
    }
    /**
     * Set ContractNumber value
     * @param string $contractNumber
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setContractNumber($contractNumber = null)
    {
        // validation for constraint: string
        if (!is_null($contractNumber) && !is_string($contractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractNumber)), __LINE__);
        }
        $this->ContractNumber = $contractNumber;
        return $this;
    }
    /**
     * Get ContractModifier value
     * @return string|null
     */
    public function getContractModifier()
    {
        return $this->ContractModifier;
    }
    /**
     * Set ContractModifier value
     * @param string $contractModifier
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setContractModifier($contractModifier = null)
    {
        // validation for constraint: string
        if (!is_null($contractModifier) && !is_string($contractModifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractModifier)), __LINE__);
        }
        $this->ContractModifier = $contractModifier;
        return $this;
    }
    /**
     * Get IsRenewal value
     * @return bool|null
     */
    public function getIsRenewal()
    {
        return $this->IsRenewal;
    }
    /**
     * Set IsRenewal value
     * @param bool $isRenewal
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public function setIsRenewal($isRenewal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRenewal) && !is_bool($isRenewal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRenewal)), __LINE__);
        }
        $this->IsRenewal = $isRenewal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Subscription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
