<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriberSendResult StructType
 * @subpackage Structs
 */
class SubscriberSendResult extends APIObject
{
    /**
     * The Send
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Send
     */
    public $Send;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Email
     */
    public $Email;
    /**
     * The Subscriber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Subscriber
     */
    public $Subscriber;
    /**
     * The ClickDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClickDate;
    /**
     * The BounceDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BounceDate;
    /**
     * The OpenDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OpenDate;
    /**
     * The SentDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SentDate;
    /**
     * The LastAction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastAction;
    /**
     * The UnsubscribeDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnsubscribeDate;
    /**
     * The FromAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromAddress;
    /**
     * The FromName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromName;
    /**
     * The TotalClicks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $TotalClicks;
    /**
     * The UniqueClicks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $UniqueClicks;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Subject;
    /**
     * The ViewSentEmailURL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ViewSentEmailURL;
    /**
     * The HardBounces
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $HardBounces;
    /**
     * The SoftBounces
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $SoftBounces;
    /**
     * The OtherBounces
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OtherBounces;
    /**
     * Constructor method for SubscriberSendResult
     * @uses SubscriberSendResult::setSend()
     * @uses SubscriberSendResult::setEmail()
     * @uses SubscriberSendResult::setSubscriber()
     * @uses SubscriberSendResult::setClickDate()
     * @uses SubscriberSendResult::setBounceDate()
     * @uses SubscriberSendResult::setOpenDate()
     * @uses SubscriberSendResult::setSentDate()
     * @uses SubscriberSendResult::setLastAction()
     * @uses SubscriberSendResult::setUnsubscribeDate()
     * @uses SubscriberSendResult::setFromAddress()
     * @uses SubscriberSendResult::setFromName()
     * @uses SubscriberSendResult::setTotalClicks()
     * @uses SubscriberSendResult::setUniqueClicks()
     * @uses SubscriberSendResult::setSubject()
     * @uses SubscriberSendResult::setViewSentEmailURL()
     * @uses SubscriberSendResult::setHardBounces()
     * @uses SubscriberSendResult::setSoftBounces()
     * @uses SubscriberSendResult::setOtherBounces()
     * @param \App\Library\ExactTarget\StructType\Send $send
     * @param \App\Library\ExactTarget\StructType\Email $email
     * @param \App\Library\ExactTarget\StructType\Subscriber $subscriber
     * @param string $clickDate
     * @param string $bounceDate
     * @param string $openDate
     * @param string $sentDate
     * @param string $lastAction
     * @param string $unsubscribeDate
     * @param string $fromAddress
     * @param string $fromName
     * @param int $totalClicks
     * @param int $uniqueClicks
     * @param string $subject
     * @param string $viewSentEmailURL
     * @param int $hardBounces
     * @param int $softBounces
     * @param int $otherBounces
     */
    public function __construct(\App\Library\ExactTarget\StructType\Send $send = null, \App\Library\ExactTarget\StructType\Email $email = null, \App\Library\ExactTarget\StructType\Subscriber $subscriber = null, $clickDate = null, $bounceDate = null, $openDate = null, $sentDate = null, $lastAction = null, $unsubscribeDate = null, $fromAddress = null, $fromName = null, $totalClicks = null, $uniqueClicks = null, $subject = null, $viewSentEmailURL = null, $hardBounces = null, $softBounces = null, $otherBounces = null)
    {
        $this
            ->setSend($send)
            ->setEmail($email)
            ->setSubscriber($subscriber)
            ->setClickDate($clickDate)
            ->setBounceDate($bounceDate)
            ->setOpenDate($openDate)
            ->setSentDate($sentDate)
            ->setLastAction($lastAction)
            ->setUnsubscribeDate($unsubscribeDate)
            ->setFromAddress($fromAddress)
            ->setFromName($fromName)
            ->setTotalClicks($totalClicks)
            ->setUniqueClicks($uniqueClicks)
            ->setSubject($subject)
            ->setViewSentEmailURL($viewSentEmailURL)
            ->setHardBounces($hardBounces)
            ->setSoftBounces($softBounces)
            ->setOtherBounces($otherBounces);
    }
    /**
     * Get Send value
     * @return \App\Library\ExactTarget\StructType\Send|null
     */
    public function getSend()
    {
        return $this->Send;
    }
    /**
     * Set Send value
     * @param \App\Library\ExactTarget\StructType\Send $send
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setSend(\App\Library\ExactTarget\StructType\Send $send = null)
    {
        $this->Send = $send;
        return $this;
    }
    /**
     * Get Email value
     * @return \App\Library\ExactTarget\StructType\Email|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \App\Library\ExactTarget\StructType\Email $email
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setEmail(\App\Library\ExactTarget\StructType\Email $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Subscriber value
     * @return \App\Library\ExactTarget\StructType\Subscriber|null
     */
    public function getSubscriber()
    {
        return $this->Subscriber;
    }
    /**
     * Set Subscriber value
     * @param \App\Library\ExactTarget\StructType\Subscriber $subscriber
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setSubscriber(\App\Library\ExactTarget\StructType\Subscriber $subscriber = null)
    {
        $this->Subscriber = $subscriber;
        return $this;
    }
    /**
     * Get ClickDate value
     * @return string|null
     */
    public function getClickDate()
    {
        return $this->ClickDate;
    }
    /**
     * Set ClickDate value
     * @param string $clickDate
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setClickDate($clickDate = null)
    {
        // validation for constraint: string
        if (!is_null($clickDate) && !is_string($clickDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clickDate)), __LINE__);
        }
        $this->ClickDate = $clickDate;
        return $this;
    }
    /**
     * Get BounceDate value
     * @return string|null
     */
    public function getBounceDate()
    {
        return $this->BounceDate;
    }
    /**
     * Set BounceDate value
     * @param string $bounceDate
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setBounceDate($bounceDate = null)
    {
        // validation for constraint: string
        if (!is_null($bounceDate) && !is_string($bounceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bounceDate)), __LINE__);
        }
        $this->BounceDate = $bounceDate;
        return $this;
    }
    /**
     * Get OpenDate value
     * @return string|null
     */
    public function getOpenDate()
    {
        return $this->OpenDate;
    }
    /**
     * Set OpenDate value
     * @param string $openDate
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setOpenDate($openDate = null)
    {
        // validation for constraint: string
        if (!is_null($openDate) && !is_string($openDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($openDate)), __LINE__);
        }
        $this->OpenDate = $openDate;
        return $this;
    }
    /**
     * Get SentDate value
     * @return string|null
     */
    public function getSentDate()
    {
        return $this->SentDate;
    }
    /**
     * Set SentDate value
     * @param string $sentDate
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setSentDate($sentDate = null)
    {
        // validation for constraint: string
        if (!is_null($sentDate) && !is_string($sentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sentDate)), __LINE__);
        }
        $this->SentDate = $sentDate;
        return $this;
    }
    /**
     * Get LastAction value
     * @return string|null
     */
    public function getLastAction()
    {
        return $this->LastAction;
    }
    /**
     * Set LastAction value
     * @param string $lastAction
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setLastAction($lastAction = null)
    {
        // validation for constraint: string
        if (!is_null($lastAction) && !is_string($lastAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastAction)), __LINE__);
        }
        $this->LastAction = $lastAction;
        return $this;
    }
    /**
     * Get UnsubscribeDate value
     * @return string|null
     */
    public function getUnsubscribeDate()
    {
        return $this->UnsubscribeDate;
    }
    /**
     * Set UnsubscribeDate value
     * @param string $unsubscribeDate
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setUnsubscribeDate($unsubscribeDate = null)
    {
        // validation for constraint: string
        if (!is_null($unsubscribeDate) && !is_string($unsubscribeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unsubscribeDate)), __LINE__);
        }
        $this->UnsubscribeDate = $unsubscribeDate;
        return $this;
    }
    /**
     * Get FromAddress value
     * @return string|null
     */
    public function getFromAddress()
    {
        return $this->FromAddress;
    }
    /**
     * Set FromAddress value
     * @param string $fromAddress
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setFromAddress($fromAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fromAddress) && !is_string($fromAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromAddress)), __LINE__);
        }
        $this->FromAddress = $fromAddress;
        return $this;
    }
    /**
     * Get FromName value
     * @return string|null
     */
    public function getFromName()
    {
        return $this->FromName;
    }
    /**
     * Set FromName value
     * @param string $fromName
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setFromName($fromName = null)
    {
        // validation for constraint: string
        if (!is_null($fromName) && !is_string($fromName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromName)), __LINE__);
        }
        $this->FromName = $fromName;
        return $this;
    }
    /**
     * Get TotalClicks value
     * @return int|null
     */
    public function getTotalClicks()
    {
        return $this->TotalClicks;
    }
    /**
     * Set TotalClicks value
     * @param int $totalClicks
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setTotalClicks($totalClicks = null)
    {
        // validation for constraint: int
        if (!is_null($totalClicks) && !is_numeric($totalClicks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalClicks)), __LINE__);
        }
        $this->TotalClicks = $totalClicks;
        return $this;
    }
    /**
     * Get UniqueClicks value
     * @return int|null
     */
    public function getUniqueClicks()
    {
        return $this->UniqueClicks;
    }
    /**
     * Set UniqueClicks value
     * @param int $uniqueClicks
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setUniqueClicks($uniqueClicks = null)
    {
        // validation for constraint: int
        if (!is_null($uniqueClicks) && !is_numeric($uniqueClicks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uniqueClicks)), __LINE__);
        }
        $this->UniqueClicks = $uniqueClicks;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get ViewSentEmailURL value
     * @return string|null
     */
    public function getViewSentEmailURL()
    {
        return $this->ViewSentEmailURL;
    }
    /**
     * Set ViewSentEmailURL value
     * @param string $viewSentEmailURL
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setViewSentEmailURL($viewSentEmailURL = null)
    {
        // validation for constraint: string
        if (!is_null($viewSentEmailURL) && !is_string($viewSentEmailURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($viewSentEmailURL)), __LINE__);
        }
        $this->ViewSentEmailURL = $viewSentEmailURL;
        return $this;
    }
    /**
     * Get HardBounces value
     * @return int|null
     */
    public function getHardBounces()
    {
        return $this->HardBounces;
    }
    /**
     * Set HardBounces value
     * @param int $hardBounces
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setHardBounces($hardBounces = null)
    {
        // validation for constraint: int
        if (!is_null($hardBounces) && !is_numeric($hardBounces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($hardBounces)), __LINE__);
        }
        $this->HardBounces = $hardBounces;
        return $this;
    }
    /**
     * Get SoftBounces value
     * @return int|null
     */
    public function getSoftBounces()
    {
        return $this->SoftBounces;
    }
    /**
     * Set SoftBounces value
     * @param int $softBounces
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setSoftBounces($softBounces = null)
    {
        // validation for constraint: int
        if (!is_null($softBounces) && !is_numeric($softBounces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($softBounces)), __LINE__);
        }
        $this->SoftBounces = $softBounces;
        return $this;
    }
    /**
     * Get OtherBounces value
     * @return int|null
     */
    public function getOtherBounces()
    {
        return $this->OtherBounces;
    }
    /**
     * Set OtherBounces value
     * @param int $otherBounces
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public function setOtherBounces($otherBounces = null)
    {
        // validation for constraint: int
        if (!is_null($otherBounces) && !is_numeric($otherBounces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($otherBounces)), __LINE__);
        }
        $this->OtherBounces = $otherBounces;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SubscriberSendResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
