<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriberResult StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SubscriberResult
 * @subpackage Structs
 */
class SubscriberResult extends AbstractStructBase
{
    /**
     * The Subscriber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\Subscriber
     */
    public $Subscriber;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErrorCode;
    /**
     * The ErrorDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorDescription;
    /**
     * The Ordinal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Ordinal;
    /**
     * Constructor method for SubscriberResult
     * @uses SubscriberResult::setSubscriber()
     * @uses SubscriberResult::setErrorCode()
     * @uses SubscriberResult::setErrorDescription()
     * @uses SubscriberResult::setOrdinal()
     * @param \App\Library\ExactTarget\StructType\Subscriber $subscriber
     * @param string $errorCode
     * @param string $errorDescription
     * @param int $ordinal
     */
    public function __construct(\App\Library\ExactTarget\StructType\Subscriber $subscriber = null, $errorCode = null, $errorDescription = null, $ordinal = null)
    {
        $this
            ->setSubscriber($subscriber)
            ->setErrorCode($errorCode)
            ->setErrorDescription($errorDescription)
            ->setOrdinal($ordinal);
    }
    /**
     * Get Subscriber value
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function getSubscriber()
    {
        return $this->Subscriber;
    }
    /**
     * Set Subscriber value
     * @param \App\Library\ExactTarget\StructType\Subscriber $subscriber
     * @return \App\Library\ExactTarget\StructType\SubscriberResult
     */
    public function setSubscriber(\App\Library\ExactTarget\StructType\Subscriber $subscriber = null)
    {
        $this->Subscriber = $subscriber;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \App\Library\ExactTarget\StructType\SubscriberResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get ErrorDescription value
     * @return string|null
     */
    public function getErrorDescription()
    {
        return $this->ErrorDescription;
    }
    /**
     * Set ErrorDescription value
     * @param string $errorDescription
     * @return \App\Library\ExactTarget\StructType\SubscriberResult
     */
    public function setErrorDescription($errorDescription = null)
    {
        // validation for constraint: string
        if (!is_null($errorDescription) && !is_string($errorDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorDescription)), __LINE__);
        }
        $this->ErrorDescription = $errorDescription;
        return $this;
    }
    /**
     * Get Ordinal value
     * @return int|null
     */
    public function getOrdinal()
    {
        return $this->Ordinal;
    }
    /**
     * Set Ordinal value
     * @param int $ordinal
     * @return \App\Library\ExactTarget\StructType\SubscriberResult
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !is_numeric($ordinal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ordinal)), __LINE__);
        }
        $this->Ordinal = $ordinal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SubscriberResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
