<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriberList StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SubscriberList
 * @subpackage Structs
 */
class SubscriberList extends APIObject
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The List
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\_List
     */
    public $List;
    /**
     * The Action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Action;
    /**
     * The Subscriber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Subscriber
     */
    public $Subscriber;
    /**
     * Constructor method for SubscriberList
     * @uses SubscriberList::setStatus()
     * @uses SubscriberList::setList()
     * @uses SubscriberList::setAction()
     * @uses SubscriberList::setSubscriber()
     * @param string $status
     * @param \App\Library\ExactTarget\StructType\_List $list
     * @param string $action
     * @param \App\Library\ExactTarget\StructType\Subscriber $subscriber
     */
    public function __construct($status = null, \App\Library\ExactTarget\StructType\_List $list = null, $action = null, \App\Library\ExactTarget\StructType\Subscriber $subscriber = null)
    {
        $this
            ->setStatus($status)
            ->setList($list)
            ->setAction($action)
            ->setSubscriber($subscriber);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \App\Library\ExactTarget\EnumType\SubscriberStatus::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SubscriberStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \App\Library\ExactTarget\StructType\SubscriberList
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SubscriberStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \App\Library\ExactTarget\EnumType\SubscriberStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get List value
     * @return \App\Library\ExactTarget\StructType\_List|null
     */
    public function getList()
    {
        return $this->List;
    }
    /**
     * Set List value
     * @param \App\Library\ExactTarget\StructType\_List $list
     * @return \App\Library\ExactTarget\StructType\SubscriberList
     */
    public function setList(\App\Library\ExactTarget\StructType\_List $list = null)
    {
        $this->List = $list;
        return $this;
    }
    /**
     * Get Action value
     * @return string|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param string $action
     * @return \App\Library\ExactTarget\StructType\SubscriberList
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($action)), __LINE__);
        }
        $this->Action = $action;
        return $this;
    }
    /**
     * Get Subscriber value
     * @return \App\Library\ExactTarget\StructType\Subscriber|null
     */
    public function getSubscriber()
    {
        return $this->Subscriber;
    }
    /**
     * Set Subscriber value
     * @param \App\Library\ExactTarget\StructType\Subscriber $subscriber
     * @return \App\Library\ExactTarget\StructType\SubscriberList
     */
    public function setSubscriber(\App\Library\ExactTarget\StructType\Subscriber $subscriber = null)
    {
        $this->Subscriber = $subscriber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SubscriberList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
