<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriberAddress StructType
 * @subpackage Structs
 */
class SubscriberAddress extends AbstractStructBase
{
    /**
     * The AddressType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AddressType;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The Statuses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Statuses
     */
    public $Statuses;
    /**
     * Constructor method for SubscriberAddress
     * @uses SubscriberAddress::setAddressType()
     * @uses SubscriberAddress::setAddress()
     * @uses SubscriberAddress::setStatuses()
     * @param string $addressType
     * @param string $address
     * @param \App\Library\ExactTarget\StructType\Statuses $statuses
     */
    public function __construct($addressType = null, $address = null, \App\Library\ExactTarget\StructType\Statuses $statuses = null)
    {
        $this
            ->setAddressType($addressType)
            ->setAddress($address)
            ->setStatuses($statuses);
    }
    /**
     * Get AddressType value
     * @return string|null
     */
    public function getAddressType()
    {
        return $this->AddressType;
    }
    /**
     * Set AddressType value
     * @param string $addressType
     * @return \App\Library\ExactTarget\StructType\SubscriberAddress
     */
    public function setAddressType($addressType = null)
    {
        // validation for constraint: string
        if (!is_null($addressType) && !is_string($addressType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressType)), __LINE__);
        }
        $this->AddressType = $addressType;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \App\Library\ExactTarget\StructType\SubscriberAddress
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Statuses value
     * @return \App\Library\ExactTarget\StructType\Statuses|null
     */
    public function getStatuses()
    {
        return $this->Statuses;
    }
    /**
     * Set Statuses value
     * @param \App\Library\ExactTarget\StructType\Statuses $statuses
     * @return \App\Library\ExactTarget\StructType\SubscriberAddress
     */
    public function setStatuses(\App\Library\ExactTarget\StructType\Statuses $statuses = null)
    {
        $this->Statuses = $statuses;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SubscriberAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
