<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subscriber StructType
 * Meta informations extracted from the WSDL
 * - type: tns:Subscriber
 * @subpackage Structs
 */
class Subscriber extends APIObject
{
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The Attributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Attribute[]
     */
    public $Attributes;
    /**
     * The SubscriberKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubscriberKey;
    /**
     * The UnsubscribedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnsubscribedDate;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The PartnerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartnerType;
    /**
     * The EmailTypePreference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailTypePreference;
    /**
     * The Lists
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SubscriberList[]
     */
    public $Lists;
    /**
     * The GlobalUnsubscribeCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\GlobalUnsubscribeCategory
     */
    public $GlobalUnsubscribeCategory;
    /**
     * The SubscriberTypeDefinition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SubscriberTypeDefinition
     */
    public $SubscriberTypeDefinition;
    /**
     * The Addresses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Addresses
     */
    public $Addresses;
    /**
     * The PrimarySMSAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SMSAddress
     */
    public $PrimarySMSAddress;
    /**
     * The PrimarySMSPublicationStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PrimarySMSPublicationStatus;
    /**
     * The PrimaryEmailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\EmailAddress
     */
    public $PrimaryEmailAddress;
    /**
     * The Locale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Locale
     */
    public $Locale;
    /**
     * Constructor method for Subscriber
     * @uses Subscriber::setEmailAddress()
     * @uses Subscriber::setAttributes()
     * @uses Subscriber::setSubscriberKey()
     * @uses Subscriber::setUnsubscribedDate()
     * @uses Subscriber::setStatus()
     * @uses Subscriber::setPartnerType()
     * @uses Subscriber::setEmailTypePreference()
     * @uses Subscriber::setLists()
     * @uses Subscriber::setGlobalUnsubscribeCategory()
     * @uses Subscriber::setSubscriberTypeDefinition()
     * @uses Subscriber::setAddresses()
     * @uses Subscriber::setPrimarySMSAddress()
     * @uses Subscriber::setPrimarySMSPublicationStatus()
     * @uses Subscriber::setPrimaryEmailAddress()
     * @uses Subscriber::setLocale()
     * @param string $emailAddress
     * @param \App\Library\ExactTarget\StructType\Attribute[] $attributes
     * @param string $subscriberKey
     * @param string $unsubscribedDate
     * @param string $status
     * @param string $partnerType
     * @param string $emailTypePreference
     * @param \App\Library\ExactTarget\StructType\SubscriberList[] $lists
     * @param \App\Library\ExactTarget\StructType\GlobalUnsubscribeCategory $globalUnsubscribeCategory
     * @param \App\Library\ExactTarget\StructType\SubscriberTypeDefinition $subscriberTypeDefinition
     * @param \App\Library\ExactTarget\StructType\Addresses $addresses
     * @param \App\Library\ExactTarget\StructType\SMSAddress $primarySMSAddress
     * @param string $primarySMSPublicationStatus
     * @param \App\Library\ExactTarget\StructType\EmailAddress $primaryEmailAddress
     * @param \App\Library\ExactTarget\StructType\Locale $locale
     */
    public function __construct($emailAddress = null, array $attributes = array(), $subscriberKey = null, $unsubscribedDate = null, $status = null, $partnerType = null, $emailTypePreference = null, array $lists = array(), \App\Library\ExactTarget\StructType\GlobalUnsubscribeCategory $globalUnsubscribeCategory = null, \App\Library\ExactTarget\StructType\SubscriberTypeDefinition $subscriberTypeDefinition = null, \App\Library\ExactTarget\StructType\Addresses $addresses = null, \App\Library\ExactTarget\StructType\SMSAddress $primarySMSAddress = null, $primarySMSPublicationStatus = null, \App\Library\ExactTarget\StructType\EmailAddress $primaryEmailAddress = null, \App\Library\ExactTarget\StructType\Locale $locale = null)
    {
        $this
            ->setEmailAddress($emailAddress)
            ->setAttributes($attributes)
            ->setSubscriberKey($subscriberKey)
            ->setUnsubscribedDate($unsubscribedDate)
            ->setStatus($status)
            ->setPartnerType($partnerType)
            ->setEmailTypePreference($emailTypePreference)
            ->setLists($lists)
            ->setGlobalUnsubscribeCategory($globalUnsubscribeCategory)
            ->setSubscriberTypeDefinition($subscriberTypeDefinition)
            ->setAddresses($addresses)
            ->setPrimarySMSAddress($primarySMSAddress)
            ->setPrimarySMSPublicationStatus($primarySMSPublicationStatus)
            ->setPrimaryEmailAddress($primaryEmailAddress)
            ->setLocale($locale);
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get Attributes value
     * @return \App\Library\ExactTarget\StructType\Attribute[]|null
     */
    public function getAttributes()
    {
        return $this->Attributes;
    }
    /**
     * Set Attributes value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Attribute[] $attributes
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setAttributes(array $attributes = array())
    {
        foreach ($attributes as $subscriberAttributesItem) {
            // validation for constraint: itemType
            if (!$subscriberAttributesItem instanceof \App\Library\ExactTarget\StructType\Attribute) {
                throw new \InvalidArgumentException(sprintf('The Attributes property can only contain items of \App\Library\ExactTarget\StructType\Attribute, "%s" given', is_object($subscriberAttributesItem) ? get_class($subscriberAttributesItem) : gettype($subscriberAttributesItem)), __LINE__);
            }
        }
        $this->Attributes = $attributes;
        return $this;
    }
    /**
     * Add item to Attributes value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Attribute $item
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function addToAttributes(\App\Library\ExactTarget\StructType\Attribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\Attribute) {
            throw new \InvalidArgumentException(sprintf('The Attributes property can only contain items of \App\Library\ExactTarget\StructType\Attribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Attributes[] = $item;
        return $this;
    }
    /**
     * Get SubscriberKey value
     * @return string|null
     */
    public function getSubscriberKey()
    {
        return $this->SubscriberKey;
    }
    /**
     * Set SubscriberKey value
     * @param string $subscriberKey
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setSubscriberKey($subscriberKey = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberKey) && !is_string($subscriberKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberKey)), __LINE__);
        }
        $this->SubscriberKey = $subscriberKey;
        return $this;
    }
    /**
     * Get UnsubscribedDate value
     * @return string|null
     */
    public function getUnsubscribedDate()
    {
        return $this->UnsubscribedDate;
    }
    /**
     * Set UnsubscribedDate value
     * @param string $unsubscribedDate
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setUnsubscribedDate($unsubscribedDate = null)
    {
        // validation for constraint: string
        if (!is_null($unsubscribedDate) && !is_string($unsubscribedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unsubscribedDate)), __LINE__);
        }
        $this->UnsubscribedDate = $unsubscribedDate;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \App\Library\ExactTarget\EnumType\SubscriberStatus::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SubscriberStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SubscriberStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \App\Library\ExactTarget\EnumType\SubscriberStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PartnerType value
     * @return string|null
     */
    public function getPartnerType()
    {
        return $this->PartnerType;
    }
    /**
     * Set PartnerType value
     * @param string $partnerType
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setPartnerType($partnerType = null)
    {
        // validation for constraint: string
        if (!is_null($partnerType) && !is_string($partnerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partnerType)), __LINE__);
        }
        $this->PartnerType = $partnerType;
        return $this;
    }
    /**
     * Get EmailTypePreference value
     * @return string|null
     */
    public function getEmailTypePreference()
    {
        return $this->EmailTypePreference;
    }
    /**
     * Set EmailTypePreference value
     * @uses \App\Library\ExactTarget\EnumType\EmailType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\EmailType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $emailTypePreference
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setEmailTypePreference($emailTypePreference = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\EmailType::valueIsValid($emailTypePreference)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $emailTypePreference, implode(', ', \App\Library\ExactTarget\EnumType\EmailType::getValidValues())), __LINE__);
        }
        $this->EmailTypePreference = $emailTypePreference;
        return $this;
    }
    /**
     * Get Lists value
     * @return \App\Library\ExactTarget\StructType\SubscriberList[]|null
     */
    public function getLists()
    {
        return $this->Lists;
    }
    /**
     * Set Lists value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\SubscriberList[] $lists
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setLists(array $lists = array())
    {
        foreach ($lists as $subscriberListsItem) {
            // validation for constraint: itemType
            if (!$subscriberListsItem instanceof \App\Library\ExactTarget\StructType\SubscriberList) {
                throw new \InvalidArgumentException(sprintf('The Lists property can only contain items of \App\Library\ExactTarget\StructType\SubscriberList, "%s" given', is_object($subscriberListsItem) ? get_class($subscriberListsItem) : gettype($subscriberListsItem)), __LINE__);
            }
        }
        $this->Lists = $lists;
        return $this;
    }
    /**
     * Add item to Lists value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\SubscriberList $item
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function addToLists(\App\Library\ExactTarget\StructType\SubscriberList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\SubscriberList) {
            throw new \InvalidArgumentException(sprintf('The Lists property can only contain items of \App\Library\ExactTarget\StructType\SubscriberList, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Lists[] = $item;
        return $this;
    }
    /**
     * Get GlobalUnsubscribeCategory value
     * @return \App\Library\ExactTarget\StructType\GlobalUnsubscribeCategory|null
     */
    public function getGlobalUnsubscribeCategory()
    {
        return $this->GlobalUnsubscribeCategory;
    }
    /**
     * Set GlobalUnsubscribeCategory value
     * @param \App\Library\ExactTarget\StructType\GlobalUnsubscribeCategory $globalUnsubscribeCategory
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setGlobalUnsubscribeCategory(\App\Library\ExactTarget\StructType\GlobalUnsubscribeCategory $globalUnsubscribeCategory = null)
    {
        $this->GlobalUnsubscribeCategory = $globalUnsubscribeCategory;
        return $this;
    }
    /**
     * Get SubscriberTypeDefinition value
     * @return \App\Library\ExactTarget\StructType\SubscriberTypeDefinition|null
     */
    public function getSubscriberTypeDefinition()
    {
        return $this->SubscriberTypeDefinition;
    }
    /**
     * Set SubscriberTypeDefinition value
     * @param \App\Library\ExactTarget\StructType\SubscriberTypeDefinition $subscriberTypeDefinition
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setSubscriberTypeDefinition(\App\Library\ExactTarget\StructType\SubscriberTypeDefinition $subscriberTypeDefinition = null)
    {
        $this->SubscriberTypeDefinition = $subscriberTypeDefinition;
        return $this;
    }
    /**
     * Get Addresses value
     * @return \App\Library\ExactTarget\StructType\Addresses|null
     */
    public function getAddresses()
    {
        return $this->Addresses;
    }
    /**
     * Set Addresses value
     * @param \App\Library\ExactTarget\StructType\Addresses $addresses
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setAddresses(\App\Library\ExactTarget\StructType\Addresses $addresses = null)
    {
        $this->Addresses = $addresses;
        return $this;
    }
    /**
     * Get PrimarySMSAddress value
     * @return \App\Library\ExactTarget\StructType\SMSAddress|null
     */
    public function getPrimarySMSAddress()
    {
        return $this->PrimarySMSAddress;
    }
    /**
     * Set PrimarySMSAddress value
     * @param \App\Library\ExactTarget\StructType\SMSAddress $primarySMSAddress
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setPrimarySMSAddress(\App\Library\ExactTarget\StructType\SMSAddress $primarySMSAddress = null)
    {
        $this->PrimarySMSAddress = $primarySMSAddress;
        return $this;
    }
    /**
     * Get PrimarySMSPublicationStatus value
     * @return string|null
     */
    public function getPrimarySMSPublicationStatus()
    {
        return $this->PrimarySMSPublicationStatus;
    }
    /**
     * Set PrimarySMSPublicationStatus value
     * @uses \App\Library\ExactTarget\EnumType\SubscriberAddressStatus::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SubscriberAddressStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $primarySMSPublicationStatus
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setPrimarySMSPublicationStatus($primarySMSPublicationStatus = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SubscriberAddressStatus::valueIsValid($primarySMSPublicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $primarySMSPublicationStatus, implode(', ', \App\Library\ExactTarget\EnumType\SubscriberAddressStatus::getValidValues())), __LINE__);
        }
        $this->PrimarySMSPublicationStatus = $primarySMSPublicationStatus;
        return $this;
    }
    /**
     * Get PrimaryEmailAddress value
     * @return \App\Library\ExactTarget\StructType\EmailAddress|null
     */
    public function getPrimaryEmailAddress()
    {
        return $this->PrimaryEmailAddress;
    }
    /**
     * Set PrimaryEmailAddress value
     * @param \App\Library\ExactTarget\StructType\EmailAddress $primaryEmailAddress
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setPrimaryEmailAddress(\App\Library\ExactTarget\StructType\EmailAddress $primaryEmailAddress = null)
    {
        $this->PrimaryEmailAddress = $primaryEmailAddress;
        return $this;
    }
    /**
     * Get Locale value
     * @return \App\Library\ExactTarget\StructType\Locale|null
     */
    public function getLocale()
    {
        return $this->Locale;
    }
    /**
     * Set Locale value
     * @param \App\Library\ExactTarget\StructType\Locale $locale
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public function setLocale(\App\Library\ExactTarget\StructType\Locale $locale = null)
    {
        $this->Locale = $locale;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Subscriber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
