<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sources StructType
 * @subpackage Structs
 */
class Sources extends AbstractStructBase
{
    /**
     * The Source
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIObject[]
     */
    public $Source;
    /**
     * Constructor method for Sources
     * @uses Sources::setSource()
     * @param \App\Library\ExactTarget\StructType\APIObject[] $source
     */
    public function __construct(array $source = array())
    {
        $this
            ->setSource($source);
    }
    /**
     * Get Source value
     * @return \App\Library\ExactTarget\StructType\APIObject[]|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIObject[] $source
     * @return \App\Library\ExactTarget\StructType\Sources
     */
    public function setSource(array $source = array())
    {
        foreach ($source as $sourcesSourceItem) {
            // validation for constraint: itemType
            if (!$sourcesSourceItem instanceof \App\Library\ExactTarget\StructType\APIObject) {
                throw new \InvalidArgumentException(sprintf('The Source property can only contain items of \App\Library\ExactTarget\StructType\APIObject, "%s" given', is_object($sourcesSourceItem) ? get_class($sourcesSourceItem) : gettype($sourcesSourceItem)), __LINE__);
            }
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Add item to Source value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIObject $item
     * @return \App\Library\ExactTarget\StructType\Sources
     */
    public function addToSource(\App\Library\ExactTarget\StructType\APIObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIObject) {
            throw new \InvalidArgumentException(sprintf('The Source property can only contain items of \App\Library\ExactTarget\StructType\APIObject, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Source[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Sources
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
