<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleFilterPart StructType
 * @subpackage Structs
 */
class SimpleFilterPart extends FilterPart
{
    /**
     * The Property
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Property;
    /**
     * The SimpleOperator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SimpleOperator;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Value;
    /**
     * The DateValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $DateValue;
    /**
     * Constructor method for SimpleFilterPart
     * @uses SimpleFilterPart::setProperty()
     * @uses SimpleFilterPart::setSimpleOperator()
     * @uses SimpleFilterPart::setValue()
     * @uses SimpleFilterPart::setDateValue()
     * @param string $property
     * @param string $simpleOperator
     * @param string[] $value
     * @param string[] $dateValue
     */
    public function __construct($property = null, $simpleOperator = null, array $value = array(), array $dateValue = array())
    {
        $this
            ->setProperty($property)
            ->setSimpleOperator($simpleOperator)
            ->setValue($value)
            ->setDateValue($dateValue);
    }
    /**
     * Get Property value
     * @return string
     */
    public function getProperty()
    {
        return $this->Property;
    }
    /**
     * Set Property value
     * @param string $property
     * @return \App\Library\ExactTarget\StructType\SimpleFilterPart
     */
    public function setProperty($property = null)
    {
        // validation for constraint: string
        if (!is_null($property) && !is_string($property)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($property)), __LINE__);
        }
        $this->Property = $property;
        return $this;
    }
    /**
     * Get SimpleOperator value
     * @return string
     */
    public function getSimpleOperator()
    {
        return $this->SimpleOperator;
    }
    /**
     * Set SimpleOperator value
     * @uses \App\Library\ExactTarget\EnumType\SimpleOperators::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SimpleOperators::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $simpleOperator
     * @return \App\Library\ExactTarget\StructType\SimpleFilterPart
     */
    public function setSimpleOperator($simpleOperator = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SimpleOperators::valueIsValid($simpleOperator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $simpleOperator, implode(', ', \App\Library\ExactTarget\EnumType\SimpleOperators::getValidValues())), __LINE__);
        }
        $this->SimpleOperator = $simpleOperator;
        return $this;
    }
    /**
     * Get Value value
     * @return string[]|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @throws \InvalidArgumentException
     * @param string[] $value
     * @return \App\Library\ExactTarget\StructType\SimpleFilterPart
     */
    public function setValue(array $value = array())
    {
        foreach ($value as $simpleFilterPartValueItem) {
            // validation for constraint: itemType
            if (!is_string($simpleFilterPartValueItem)) {
                throw new \InvalidArgumentException(sprintf('The Value property can only contain items of string, "%s" given', is_object($simpleFilterPartValueItem) ? get_class($simpleFilterPartValueItem) : gettype($simpleFilterPartValueItem)), __LINE__);
            }
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Add item to Value value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Library\ExactTarget\StructType\SimpleFilterPart
     */
    public function addToValue($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Value property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Value[] = $item;
        return $this;
    }
    /**
     * Get DateValue value
     * @return string[]|null
     */
    public function getDateValue()
    {
        return $this->DateValue;
    }
    /**
     * Set DateValue value
     * @throws \InvalidArgumentException
     * @param string[] $dateValue
     * @return \App\Library\ExactTarget\StructType\SimpleFilterPart
     */
    public function setDateValue(array $dateValue = array())
    {
        foreach ($dateValue as $simpleFilterPartDateValueItem) {
            // validation for constraint: itemType
            if (!is_string($simpleFilterPartDateValueItem)) {
                throw new \InvalidArgumentException(sprintf('The DateValue property can only contain items of dateTime, "%s" given', is_object($simpleFilterPartDateValueItem) ? get_class($simpleFilterPartDateValueItem) : gettype($simpleFilterPartDateValueItem)), __LINE__);
            }
        }
        $this->DateValue = $dateValue;
        return $this;
    }
    /**
     * Add item to DateValue value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Library\ExactTarget\StructType\SimpleFilterPart
     */
    public function addToDateValue($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DateValue property can only contain items of dateTime, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DateValue[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SimpleFilterPart
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
