<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendDefinition StructType
 * Meta informations extracted from the WSDL
 * - type: tns:SendDefinition
 * @subpackage Structs
 */
class SendDefinition extends InteractionDefinition
{
    /**
     * The CategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CategoryID;
    /**
     * The SendClassification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SendClassification
     */
    public $SendClassification;
    /**
     * The SenderProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SenderProfile
     */
    public $SenderProfile;
    /**
     * The FromName
     * Meta informations extracted from the WSDL
     * - documentation: As of Fall 2007 SenderProfile.FromName should be used.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromName;
    /**
     * The FromAddress
     * Meta informations extracted from the WSDL
     * - documentation: As of Fall 2007 SenderProfile.FromAddress should be used.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FromAddress;
    /**
     * The DeliveryProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\DeliveryProfile
     */
    public $DeliveryProfile;
    /**
     * The SourceAddressType
     * Meta informations extracted from the WSDL
     * - documentation: As of Fall 2007 DeliveryProfile.SourceAddressType should be used.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SourceAddressType;
    /**
     * The PrivateIP
     * Meta informations extracted from the WSDL
     * - documentation: As of Fall 2007 DeliveryProfile.PrivateIP should be used.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\PrivateIP
     */
    public $PrivateIP;
    /**
     * The DomainType
     * Meta informations extracted from the WSDL
     * - documentation: As of Fall 2007 DeliveryProfile.DomainType should be used.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DomainType;
    /**
     * The PrivateDomain
     * Meta informations extracted from the WSDL
     * - documentation: As of Fall 2007 DeliveryProfile.PrivateDomain should be used.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\PrivateDomain
     */
    public $PrivateDomain;
    /**
     * The HeaderSalutationSource
     * Meta informations extracted from the WSDL
     * - documentation: As of Fall 2007 DeliveryProfile.HeaderSalutationSource should be used.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HeaderSalutationSource;
    /**
     * The HeaderContentArea
     * Meta informations extracted from the WSDL
     * - documentation: As of Fall 2007 DeliveryProfile.HeaderContentArea should be used.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ContentArea
     */
    public $HeaderContentArea;
    /**
     * The FooterSalutationSource
     * Meta informations extracted from the WSDL
     * - documentation: As of Fall 2007 DeliveryProfile.FooterSalutationSource should be used.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FooterSalutationSource;
    /**
     * The FooterContentArea
     * Meta informations extracted from the WSDL
     * - documentation: As of Fall 2007 DeliveryProfile.FooterContentArea should be used.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ContentArea
     */
    public $FooterContentArea;
    /**
     * The SuppressTracking
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SuppressTracking;
    /**
     * The IsSendLogging
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsSendLogging;
    /**
     * Constructor method for SendDefinition
     * @uses SendDefinition::setCategoryID()
     * @uses SendDefinition::setSendClassification()
     * @uses SendDefinition::setSenderProfile()
     * @uses SendDefinition::setFromName()
     * @uses SendDefinition::setFromAddress()
     * @uses SendDefinition::setDeliveryProfile()
     * @uses SendDefinition::setSourceAddressType()
     * @uses SendDefinition::setPrivateIP()
     * @uses SendDefinition::setDomainType()
     * @uses SendDefinition::setPrivateDomain()
     * @uses SendDefinition::setHeaderSalutationSource()
     * @uses SendDefinition::setHeaderContentArea()
     * @uses SendDefinition::setFooterSalutationSource()
     * @uses SendDefinition::setFooterContentArea()
     * @uses SendDefinition::setSuppressTracking()
     * @uses SendDefinition::setIsSendLogging()
     * @param int $categoryID
     * @param \App\Library\ExactTarget\StructType\SendClassification $sendClassification
     * @param \App\Library\ExactTarget\StructType\SenderProfile $senderProfile
     * @param string $fromName
     * @param string $fromAddress
     * @param \App\Library\ExactTarget\StructType\DeliveryProfile $deliveryProfile
     * @param string $sourceAddressType
     * @param \App\Library\ExactTarget\StructType\PrivateIP $privateIP
     * @param string $domainType
     * @param \App\Library\ExactTarget\StructType\PrivateDomain $privateDomain
     * @param string $headerSalutationSource
     * @param \App\Library\ExactTarget\StructType\ContentArea $headerContentArea
     * @param string $footerSalutationSource
     * @param \App\Library\ExactTarget\StructType\ContentArea $footerContentArea
     * @param bool $suppressTracking
     * @param bool $isSendLogging
     */
    public function __construct($categoryID = null, \App\Library\ExactTarget\StructType\SendClassification $sendClassification = null, \App\Library\ExactTarget\StructType\SenderProfile $senderProfile = null, $fromName = null, $fromAddress = null, \App\Library\ExactTarget\StructType\DeliveryProfile $deliveryProfile = null, $sourceAddressType = null, \App\Library\ExactTarget\StructType\PrivateIP $privateIP = null, $domainType = null, \App\Library\ExactTarget\StructType\PrivateDomain $privateDomain = null, $headerSalutationSource = null, \App\Library\ExactTarget\StructType\ContentArea $headerContentArea = null, $footerSalutationSource = null, \App\Library\ExactTarget\StructType\ContentArea $footerContentArea = null, $suppressTracking = null, $isSendLogging = null)
    {
        $this
            ->setCategoryID($categoryID)
            ->setSendClassification($sendClassification)
            ->setSenderProfile($senderProfile)
            ->setFromName($fromName)
            ->setFromAddress($fromAddress)
            ->setDeliveryProfile($deliveryProfile)
            ->setSourceAddressType($sourceAddressType)
            ->setPrivateIP($privateIP)
            ->setDomainType($domainType)
            ->setPrivateDomain($privateDomain)
            ->setHeaderSalutationSource($headerSalutationSource)
            ->setHeaderContentArea($headerContentArea)
            ->setFooterSalutationSource($footerSalutationSource)
            ->setFooterContentArea($footerContentArea)
            ->setSuppressTracking($suppressTracking)
            ->setIsSendLogging($isSendLogging);
    }
    /**
     * Get CategoryID value
     * @return int|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param int $categoryID
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: int
        if (!is_null($categoryID) && !is_numeric($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get SendClassification value
     * @return \App\Library\ExactTarget\StructType\SendClassification|null
     */
    public function getSendClassification()
    {
        return $this->SendClassification;
    }
    /**
     * Set SendClassification value
     * @param \App\Library\ExactTarget\StructType\SendClassification $sendClassification
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setSendClassification(\App\Library\ExactTarget\StructType\SendClassification $sendClassification = null)
    {
        $this->SendClassification = $sendClassification;
        return $this;
    }
    /**
     * Get SenderProfile value
     * @return \App\Library\ExactTarget\StructType\SenderProfile|null
     */
    public function getSenderProfile()
    {
        return $this->SenderProfile;
    }
    /**
     * Set SenderProfile value
     * @param \App\Library\ExactTarget\StructType\SenderProfile $senderProfile
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setSenderProfile(\App\Library\ExactTarget\StructType\SenderProfile $senderProfile = null)
    {
        $this->SenderProfile = $senderProfile;
        return $this;
    }
    /**
     * Get FromName value
     * @return string|null
     */
    public function getFromName()
    {
        return $this->FromName;
    }
    /**
     * Set FromName value
     * @param string $fromName
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setFromName($fromName = null)
    {
        // validation for constraint: string
        if (!is_null($fromName) && !is_string($fromName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromName)), __LINE__);
        }
        $this->FromName = $fromName;
        return $this;
    }
    /**
     * Get FromAddress value
     * @return string|null
     */
    public function getFromAddress()
    {
        return $this->FromAddress;
    }
    /**
     * Set FromAddress value
     * @param string $fromAddress
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setFromAddress($fromAddress = null)
    {
        // validation for constraint: string
        if (!is_null($fromAddress) && !is_string($fromAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromAddress)), __LINE__);
        }
        $this->FromAddress = $fromAddress;
        return $this;
    }
    /**
     * Get DeliveryProfile value
     * @return \App\Library\ExactTarget\StructType\DeliveryProfile|null
     */
    public function getDeliveryProfile()
    {
        return $this->DeliveryProfile;
    }
    /**
     * Set DeliveryProfile value
     * @param \App\Library\ExactTarget\StructType\DeliveryProfile $deliveryProfile
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setDeliveryProfile(\App\Library\ExactTarget\StructType\DeliveryProfile $deliveryProfile = null)
    {
        $this->DeliveryProfile = $deliveryProfile;
        return $this;
    }
    /**
     * Get SourceAddressType value
     * @return string|null
     */
    public function getSourceAddressType()
    {
        return $this->SourceAddressType;
    }
    /**
     * Set SourceAddressType value
     * @uses \App\Library\ExactTarget\EnumType\DeliveryProfileSourceAddressTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\DeliveryProfileSourceAddressTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sourceAddressType
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setSourceAddressType($sourceAddressType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\DeliveryProfileSourceAddressTypeEnum::valueIsValid($sourceAddressType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sourceAddressType, implode(', ', \App\Library\ExactTarget\EnumType\DeliveryProfileSourceAddressTypeEnum::getValidValues())), __LINE__);
        }
        $this->SourceAddressType = $sourceAddressType;
        return $this;
    }
    /**
     * Get PrivateIP value
     * @return \App\Library\ExactTarget\StructType\PrivateIP|null
     */
    public function getPrivateIP()
    {
        return $this->PrivateIP;
    }
    /**
     * Set PrivateIP value
     * @param \App\Library\ExactTarget\StructType\PrivateIP $privateIP
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setPrivateIP(\App\Library\ExactTarget\StructType\PrivateIP $privateIP = null)
    {
        $this->PrivateIP = $privateIP;
        return $this;
    }
    /**
     * Get DomainType value
     * @return string|null
     */
    public function getDomainType()
    {
        return $this->DomainType;
    }
    /**
     * Set DomainType value
     * @uses \App\Library\ExactTarget\EnumType\DeliveryProfileDomainTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\DeliveryProfileDomainTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $domainType
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setDomainType($domainType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\DeliveryProfileDomainTypeEnum::valueIsValid($domainType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $domainType, implode(', ', \App\Library\ExactTarget\EnumType\DeliveryProfileDomainTypeEnum::getValidValues())), __LINE__);
        }
        $this->DomainType = $domainType;
        return $this;
    }
    /**
     * Get PrivateDomain value
     * @return \App\Library\ExactTarget\StructType\PrivateDomain|null
     */
    public function getPrivateDomain()
    {
        return $this->PrivateDomain;
    }
    /**
     * Set PrivateDomain value
     * @param \App\Library\ExactTarget\StructType\PrivateDomain $privateDomain
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setPrivateDomain(\App\Library\ExactTarget\StructType\PrivateDomain $privateDomain = null)
    {
        $this->PrivateDomain = $privateDomain;
        return $this;
    }
    /**
     * Get HeaderSalutationSource value
     * @return string|null
     */
    public function getHeaderSalutationSource()
    {
        return $this->HeaderSalutationSource;
    }
    /**
     * Set HeaderSalutationSource value
     * @uses \App\Library\ExactTarget\EnumType\SalutationSourceEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SalutationSourceEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $headerSalutationSource
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setHeaderSalutationSource($headerSalutationSource = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SalutationSourceEnum::valueIsValid($headerSalutationSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $headerSalutationSource, implode(', ', \App\Library\ExactTarget\EnumType\SalutationSourceEnum::getValidValues())), __LINE__);
        }
        $this->HeaderSalutationSource = $headerSalutationSource;
        return $this;
    }
    /**
     * Get HeaderContentArea value
     * @return \App\Library\ExactTarget\StructType\ContentArea|null
     */
    public function getHeaderContentArea()
    {
        return $this->HeaderContentArea;
    }
    /**
     * Set HeaderContentArea value
     * @param \App\Library\ExactTarget\StructType\ContentArea $headerContentArea
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setHeaderContentArea(\App\Library\ExactTarget\StructType\ContentArea $headerContentArea = null)
    {
        $this->HeaderContentArea = $headerContentArea;
        return $this;
    }
    /**
     * Get FooterSalutationSource value
     * @return string|null
     */
    public function getFooterSalutationSource()
    {
        return $this->FooterSalutationSource;
    }
    /**
     * Set FooterSalutationSource value
     * @uses \App\Library\ExactTarget\EnumType\SalutationSourceEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\SalutationSourceEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $footerSalutationSource
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setFooterSalutationSource($footerSalutationSource = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\SalutationSourceEnum::valueIsValid($footerSalutationSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $footerSalutationSource, implode(', ', \App\Library\ExactTarget\EnumType\SalutationSourceEnum::getValidValues())), __LINE__);
        }
        $this->FooterSalutationSource = $footerSalutationSource;
        return $this;
    }
    /**
     * Get FooterContentArea value
     * @return \App\Library\ExactTarget\StructType\ContentArea|null
     */
    public function getFooterContentArea()
    {
        return $this->FooterContentArea;
    }
    /**
     * Set FooterContentArea value
     * @param \App\Library\ExactTarget\StructType\ContentArea $footerContentArea
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setFooterContentArea(\App\Library\ExactTarget\StructType\ContentArea $footerContentArea = null)
    {
        $this->FooterContentArea = $footerContentArea;
        return $this;
    }
    /**
     * Get SuppressTracking value
     * @return bool|null
     */
    public function getSuppressTracking()
    {
        return $this->SuppressTracking;
    }
    /**
     * Set SuppressTracking value
     * @param bool $suppressTracking
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setSuppressTracking($suppressTracking = null)
    {
        // validation for constraint: boolean
        if (!is_null($suppressTracking) && !is_bool($suppressTracking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($suppressTracking)), __LINE__);
        }
        $this->SuppressTracking = $suppressTracking;
        return $this;
    }
    /**
     * Get IsSendLogging value
     * @return bool|null
     */
    public function getIsSendLogging()
    {
        return $this->IsSendLogging;
    }
    /**
     * Set IsSendLogging value
     * @param bool $isSendLogging
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public function setIsSendLogging($isSendLogging = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSendLogging) && !is_bool($isSendLogging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSendLogging)), __LINE__);
        }
        $this->IsSendLogging = $isSendLogging;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SendDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
