<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendAdditionalAttribute StructType
 * @subpackage Structs
 */
class SendAdditionalAttribute extends APIObject
{
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\Email
     */
    public $Email;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Value;
    /**
     * Constructor method for SendAdditionalAttribute
     * @uses SendAdditionalAttribute::setEmail()
     * @uses SendAdditionalAttribute::setName()
     * @uses SendAdditionalAttribute::setValue()
     * @param \App\Library\ExactTarget\StructType\Email $email
     * @param string $name
     * @param string $value
     */
    public function __construct(\App\Library\ExactTarget\StructType\Email $email = null, $name = null, $value = null)
    {
        $this
            ->setEmail($email)
            ->setName($name)
            ->setValue($value);
    }
    /**
     * Get Email value
     * @return \App\Library\ExactTarget\StructType\Email
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \App\Library\ExactTarget\StructType\Email $email
     * @return \App\Library\ExactTarget\StructType\SendAdditionalAttribute
     */
    public function setEmail(\App\Library\ExactTarget\StructType\Email $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\SendAdditionalAttribute
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Value value
     * @return string
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \App\Library\ExactTarget\StructType\SendAdditionalAttribute
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SendAdditionalAttribute
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
