<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduleResponse StructType
 * @subpackage Structs
 */
class ScheduleResponse extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The StatusMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusMessage;
    /**
     * The OrdinalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OrdinalID;
    /**
     * The Results
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Results
     */
    public $Results;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * Constructor method for ScheduleResponse
     * @uses ScheduleResponse::setStatusCode()
     * @uses ScheduleResponse::setStatusMessage()
     * @uses ScheduleResponse::setOrdinalID()
     * @uses ScheduleResponse::setResults()
     * @uses ScheduleResponse::setErrorCode()
     * @param string $statusCode
     * @param string $statusMessage
     * @param int $ordinalID
     * @param \App\Library\ExactTarget\StructType\Results $results
     * @param int $errorCode
     */
    public function __construct($statusCode = null, $statusMessage = null, $ordinalID = null, \App\Library\ExactTarget\StructType\Results $results = null, $errorCode = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setStatusMessage($statusMessage)
            ->setOrdinalID($ordinalID)
            ->setResults($results)
            ->setErrorCode($errorCode);
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \App\Library\ExactTarget\StructType\ScheduleResponse
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get StatusMessage value
     * @return string|null
     */
    public function getStatusMessage()
    {
        return $this->StatusMessage;
    }
    /**
     * Set StatusMessage value
     * @param string $statusMessage
     * @return \App\Library\ExactTarget\StructType\ScheduleResponse
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusMessage)), __LINE__);
        }
        $this->StatusMessage = $statusMessage;
        return $this;
    }
    /**
     * Get OrdinalID value
     * @return int|null
     */
    public function getOrdinalID()
    {
        return $this->OrdinalID;
    }
    /**
     * Set OrdinalID value
     * @param int $ordinalID
     * @return \App\Library\ExactTarget\StructType\ScheduleResponse
     */
    public function setOrdinalID($ordinalID = null)
    {
        // validation for constraint: int
        if (!is_null($ordinalID) && !is_numeric($ordinalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ordinalID)), __LINE__);
        }
        $this->OrdinalID = $ordinalID;
        return $this;
    }
    /**
     * Get Results value
     * @return \App\Library\ExactTarget\StructType\Results|null
     */
    public function getResults()
    {
        return $this->Results;
    }
    /**
     * Set Results value
     * @param \App\Library\ExactTarget\StructType\Results $results
     * @return \App\Library\ExactTarget\StructType\ScheduleResponse
     */
    public function setResults(\App\Library\ExactTarget\StructType\Results $results = null)
    {
        $this->Results = $results;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \App\Library\ExactTarget\StructType\ScheduleResponse
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ScheduleResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
