<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScheduleDefinition StructType
 * @subpackage Structs
 */
class ScheduleDefinition extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Recurrence
     * @var \App\Library\ExactTarget\StructType\Recurrence
     */
    public $Recurrence;
    /**
     * The RecurrenceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RecurrenceType;
    /**
     * The RecurrenceRangeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RecurrenceRangeType;
    /**
     * The StartDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StartDateTime;
    /**
     * The EndDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EndDateTime;
    /**
     * The Occurrences
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Occurrences;
    /**
     * The Keyword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Keyword;
    /**
     * The TimeZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\TimeZone
     */
    public $TimeZone;
    /**
     * Constructor method for ScheduleDefinition
     * @uses ScheduleDefinition::setName()
     * @uses ScheduleDefinition::setDescription()
     * @uses ScheduleDefinition::setRecurrence()
     * @uses ScheduleDefinition::setRecurrenceType()
     * @uses ScheduleDefinition::setRecurrenceRangeType()
     * @uses ScheduleDefinition::setStartDateTime()
     * @uses ScheduleDefinition::setEndDateTime()
     * @uses ScheduleDefinition::setOccurrences()
     * @uses ScheduleDefinition::setKeyword()
     * @uses ScheduleDefinition::setTimeZone()
     * @param string $name
     * @param string $description
     * @param \App\Library\ExactTarget\StructType\Recurrence $recurrence
     * @param string $recurrenceType
     * @param string $recurrenceRangeType
     * @param string $startDateTime
     * @param string $endDateTime
     * @param int $occurrences
     * @param string $keyword
     * @param \App\Library\ExactTarget\StructType\TimeZone $timeZone
     */
    public function __construct($name = null, $description = null, \App\Library\ExactTarget\StructType\Recurrence $recurrence = null, $recurrenceType = null, $recurrenceRangeType = null, $startDateTime = null, $endDateTime = null, $occurrences = null, $keyword = null, \App\Library\ExactTarget\StructType\TimeZone $timeZone = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setRecurrence($recurrence)
            ->setRecurrenceType($recurrenceType)
            ->setRecurrenceRangeType($recurrenceRangeType)
            ->setStartDateTime($startDateTime)
            ->setEndDateTime($endDateTime)
            ->setOccurrences($occurrences)
            ->setKeyword($keyword)
            ->setTimeZone($timeZone);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\ScheduleDefinition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\ScheduleDefinition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Recurrence value
     * @return \App\Library\ExactTarget\StructType\Recurrence|null
     */
    public function getRecurrence()
    {
        return $this->Recurrence;
    }
    /**
     * Set Recurrence value
     * @param \App\Library\ExactTarget\StructType\Recurrence $recurrence
     * @return \App\Library\ExactTarget\StructType\ScheduleDefinition
     */
    public function setRecurrence(\App\Library\ExactTarget\StructType\Recurrence $recurrence = null)
    {
        $this->Recurrence = $recurrence;
        return $this;
    }
    /**
     * Get RecurrenceType value
     * @return string|null
     */
    public function getRecurrenceType()
    {
        return $this->RecurrenceType;
    }
    /**
     * Set RecurrenceType value
     * @uses \App\Library\ExactTarget\EnumType\RecurrenceTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\RecurrenceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recurrenceType
     * @return \App\Library\ExactTarget\StructType\ScheduleDefinition
     */
    public function setRecurrenceType($recurrenceType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\RecurrenceTypeEnum::valueIsValid($recurrenceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recurrenceType, implode(', ', \App\Library\ExactTarget\EnumType\RecurrenceTypeEnum::getValidValues())), __LINE__);
        }
        $this->RecurrenceType = $recurrenceType;
        return $this;
    }
    /**
     * Get RecurrenceRangeType value
     * @return string|null
     */
    public function getRecurrenceRangeType()
    {
        return $this->RecurrenceRangeType;
    }
    /**
     * Set RecurrenceRangeType value
     * @uses \App\Library\ExactTarget\EnumType\RecurrenceRangeTypeEnum::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\RecurrenceRangeTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recurrenceRangeType
     * @return \App\Library\ExactTarget\StructType\ScheduleDefinition
     */
    public function setRecurrenceRangeType($recurrenceRangeType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\RecurrenceRangeTypeEnum::valueIsValid($recurrenceRangeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recurrenceRangeType, implode(', ', \App\Library\ExactTarget\EnumType\RecurrenceRangeTypeEnum::getValidValues())), __LINE__);
        }
        $this->RecurrenceRangeType = $recurrenceRangeType;
        return $this;
    }
    /**
     * Get StartDateTime value
     * @return string|null
     */
    public function getStartDateTime()
    {
        return $this->StartDateTime;
    }
    /**
     * Set StartDateTime value
     * @param string $startDateTime
     * @return \App\Library\ExactTarget\StructType\ScheduleDefinition
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDateTime)), __LINE__);
        }
        $this->StartDateTime = $startDateTime;
        return $this;
    }
    /**
     * Get EndDateTime value
     * @return string|null
     */
    public function getEndDateTime()
    {
        return $this->EndDateTime;
    }
    /**
     * Set EndDateTime value
     * @param string $endDateTime
     * @return \App\Library\ExactTarget\StructType\ScheduleDefinition
     */
    public function setEndDateTime($endDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endDateTime) && !is_string($endDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDateTime)), __LINE__);
        }
        $this->EndDateTime = $endDateTime;
        return $this;
    }
    /**
     * Get Occurrences value
     * @return int|null
     */
    public function getOccurrences()
    {
        return $this->Occurrences;
    }
    /**
     * Set Occurrences value
     * @param int $occurrences
     * @return \App\Library\ExactTarget\StructType\ScheduleDefinition
     */
    public function setOccurrences($occurrences = null)
    {
        // validation for constraint: int
        if (!is_null($occurrences) && !is_numeric($occurrences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($occurrences)), __LINE__);
        }
        $this->Occurrences = $occurrences;
        return $this;
    }
    /**
     * Get Keyword value
     * @return string|null
     */
    public function getKeyword()
    {
        return $this->Keyword;
    }
    /**
     * Set Keyword value
     * @param string $keyword
     * @return \App\Library\ExactTarget\StructType\ScheduleDefinition
     */
    public function setKeyword($keyword = null)
    {
        // validation for constraint: string
        if (!is_null($keyword) && !is_string($keyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($keyword)), __LINE__);
        }
        $this->Keyword = $keyword;
        return $this;
    }
    /**
     * Get TimeZone value
     * @return \App\Library\ExactTarget\StructType\TimeZone|null
     */
    public function getTimeZone()
    {
        return $this->TimeZone;
    }
    /**
     * Set TimeZone value
     * @param \App\Library\ExactTarget\StructType\TimeZone $timeZone
     * @return \App\Library\ExactTarget\StructType\ScheduleDefinition
     */
    public function setTimeZone(\App\Library\ExactTarget\StructType\TimeZone $timeZone = null)
    {
        $this->TimeZone = $timeZone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ScheduleDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
