<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SMSTriggeredSendDefinition StructType
 * @subpackage Structs
 */
class SMSTriggeredSendDefinition extends SendDefinition
{
    /**
     * The Publication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\_List
     */
    public $Publication;
    /**
     * The DataExtension
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\DataExtension
     */
    public $DataExtension;
    /**
     * The Content
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ContentArea
     */
    public $Content;
    /**
     * The SendToList
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $SendToList;
    /**
     * Constructor method for SMSTriggeredSendDefinition
     * @uses SMSTriggeredSendDefinition::setPublication()
     * @uses SMSTriggeredSendDefinition::setDataExtension()
     * @uses SMSTriggeredSendDefinition::setContent()
     * @uses SMSTriggeredSendDefinition::setSendToList()
     * @param \App\Library\ExactTarget\StructType\_List $publication
     * @param \App\Library\ExactTarget\StructType\DataExtension $dataExtension
     * @param \App\Library\ExactTarget\StructType\ContentArea $content
     * @param bool $sendToList
     */
    public function __construct(\App\Library\ExactTarget\StructType\_List $publication = null, \App\Library\ExactTarget\StructType\DataExtension $dataExtension = null, \App\Library\ExactTarget\StructType\ContentArea $content = null, $sendToList = null)
    {
        $this
            ->setPublication($publication)
            ->setDataExtension($dataExtension)
            ->setContent($content)
            ->setSendToList($sendToList);
    }
    /**
     * Get Publication value
     * @return \App\Library\ExactTarget\StructType\_List|null
     */
    public function getPublication()
    {
        return $this->Publication;
    }
    /**
     * Set Publication value
     * @param \App\Library\ExactTarget\StructType\_List $publication
     * @return \App\Library\ExactTarget\StructType\SMSTriggeredSendDefinition
     */
    public function setPublication(\App\Library\ExactTarget\StructType\_List $publication = null)
    {
        $this->Publication = $publication;
        return $this;
    }
    /**
     * Get DataExtension value
     * @return \App\Library\ExactTarget\StructType\DataExtension|null
     */
    public function getDataExtension()
    {
        return $this->DataExtension;
    }
    /**
     * Set DataExtension value
     * @param \App\Library\ExactTarget\StructType\DataExtension $dataExtension
     * @return \App\Library\ExactTarget\StructType\SMSTriggeredSendDefinition
     */
    public function setDataExtension(\App\Library\ExactTarget\StructType\DataExtension $dataExtension = null)
    {
        $this->DataExtension = $dataExtension;
        return $this;
    }
    /**
     * Get Content value
     * @return \App\Library\ExactTarget\StructType\ContentArea|null
     */
    public function getContent()
    {
        return $this->Content;
    }
    /**
     * Set Content value
     * @param \App\Library\ExactTarget\StructType\ContentArea $content
     * @return \App\Library\ExactTarget\StructType\SMSTriggeredSendDefinition
     */
    public function setContent(\App\Library\ExactTarget\StructType\ContentArea $content = null)
    {
        $this->Content = $content;
        return $this;
    }
    /**
     * Get SendToList value
     * @return bool|null
     */
    public function getSendToList()
    {
        return $this->SendToList;
    }
    /**
     * Set SendToList value
     * @param bool $sendToList
     * @return \App\Library\ExactTarget\StructType\SMSTriggeredSendDefinition
     */
    public function setSendToList($sendToList = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendToList) && !is_bool($sendToList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendToList)), __LINE__);
        }
        $this->SendToList = $sendToList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SMSTriggeredSendDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
