<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SMSMOEvent StructType
 * @subpackage Structs
 */
class SMSMOEvent extends APIObject
{
    /**
     * The Keyword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\BaseMOKeyword
     */
    public $Keyword;
    /**
     * The MobileTelephoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MobileTelephoneNumber;
    /**
     * The MOCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MOCode;
    /**
     * The EventDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EventDate;
    /**
     * The MOMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MOMessage;
    /**
     * The MTMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MTMessage;
    /**
     * The Carrier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Carrier;
    /**
     * Constructor method for SMSMOEvent
     * @uses SMSMOEvent::setKeyword()
     * @uses SMSMOEvent::setMobileTelephoneNumber()
     * @uses SMSMOEvent::setMOCode()
     * @uses SMSMOEvent::setEventDate()
     * @uses SMSMOEvent::setMOMessage()
     * @uses SMSMOEvent::setMTMessage()
     * @uses SMSMOEvent::setCarrier()
     * @param \App\Library\ExactTarget\StructType\BaseMOKeyword $keyword
     * @param string $mobileTelephoneNumber
     * @param string $mOCode
     * @param string $eventDate
     * @param string $mOMessage
     * @param string $mTMessage
     * @param string $carrier
     */
    public function __construct(\App\Library\ExactTarget\StructType\BaseMOKeyword $keyword = null, $mobileTelephoneNumber = null, $mOCode = null, $eventDate = null, $mOMessage = null, $mTMessage = null, $carrier = null)
    {
        $this
            ->setKeyword($keyword)
            ->setMobileTelephoneNumber($mobileTelephoneNumber)
            ->setMOCode($mOCode)
            ->setEventDate($eventDate)
            ->setMOMessage($mOMessage)
            ->setMTMessage($mTMessage)
            ->setCarrier($carrier);
    }
    /**
     * Get Keyword value
     * @return \App\Library\ExactTarget\StructType\BaseMOKeyword|null
     */
    public function getKeyword()
    {
        return $this->Keyword;
    }
    /**
     * Set Keyword value
     * @param \App\Library\ExactTarget\StructType\BaseMOKeyword $keyword
     * @return \App\Library\ExactTarget\StructType\SMSMOEvent
     */
    public function setKeyword(\App\Library\ExactTarget\StructType\BaseMOKeyword $keyword = null)
    {
        $this->Keyword = $keyword;
        return $this;
    }
    /**
     * Get MobileTelephoneNumber value
     * @return string|null
     */
    public function getMobileTelephoneNumber()
    {
        return $this->MobileTelephoneNumber;
    }
    /**
     * Set MobileTelephoneNumber value
     * @param string $mobileTelephoneNumber
     * @return \App\Library\ExactTarget\StructType\SMSMOEvent
     */
    public function setMobileTelephoneNumber($mobileTelephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mobileTelephoneNumber) && !is_string($mobileTelephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mobileTelephoneNumber)), __LINE__);
        }
        $this->MobileTelephoneNumber = $mobileTelephoneNumber;
        return $this;
    }
    /**
     * Get MOCode value
     * @return string|null
     */
    public function getMOCode()
    {
        return $this->MOCode;
    }
    /**
     * Set MOCode value
     * @param string $mOCode
     * @return \App\Library\ExactTarget\StructType\SMSMOEvent
     */
    public function setMOCode($mOCode = null)
    {
        // validation for constraint: string
        if (!is_null($mOCode) && !is_string($mOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mOCode)), __LINE__);
        }
        $this->MOCode = $mOCode;
        return $this;
    }
    /**
     * Get EventDate value
     * @return string|null
     */
    public function getEventDate()
    {
        return $this->EventDate;
    }
    /**
     * Set EventDate value
     * @param string $eventDate
     * @return \App\Library\ExactTarget\StructType\SMSMOEvent
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventDate)), __LINE__);
        }
        $this->EventDate = $eventDate;
        return $this;
    }
    /**
     * Get MOMessage value
     * @return string|null
     */
    public function getMOMessage()
    {
        return $this->MOMessage;
    }
    /**
     * Set MOMessage value
     * @param string $mOMessage
     * @return \App\Library\ExactTarget\StructType\SMSMOEvent
     */
    public function setMOMessage($mOMessage = null)
    {
        // validation for constraint: string
        if (!is_null($mOMessage) && !is_string($mOMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mOMessage)), __LINE__);
        }
        $this->MOMessage = $mOMessage;
        return $this;
    }
    /**
     * Get MTMessage value
     * @return string|null
     */
    public function getMTMessage()
    {
        return $this->MTMessage;
    }
    /**
     * Set MTMessage value
     * @param string $mTMessage
     * @return \App\Library\ExactTarget\StructType\SMSMOEvent
     */
    public function setMTMessage($mTMessage = null)
    {
        // validation for constraint: string
        if (!is_null($mTMessage) && !is_string($mTMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mTMessage)), __LINE__);
        }
        $this->MTMessage = $mTMessage;
        return $this;
    }
    /**
     * Get Carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->Carrier;
    }
    /**
     * Set Carrier value
     * @param string $carrier
     * @return \App\Library\ExactTarget\StructType\SMSMOEvent
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: string
        if (!is_null($carrier) && !is_string($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($carrier)), __LINE__);
        }
        $this->Carrier = $carrier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\SMSMOEvent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
