<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Role StructType
 * @subpackage Structs
 */
class Role extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The IsPrivate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsPrivate;
    /**
     * The IsSystemDefined
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $IsSystemDefined;
    /**
     * The ForceInheritance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ForceInheritance;
    /**
     * The PermissionSets
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\PermissionSets
     */
    public $PermissionSets;
    /**
     * The Permissions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Permissions
     */
    public $Permissions;
    /**
     * Constructor method for Role
     * @uses Role::setName()
     * @uses Role::setDescription()
     * @uses Role::setIsPrivate()
     * @uses Role::setIsSystemDefined()
     * @uses Role::setForceInheritance()
     * @uses Role::setPermissionSets()
     * @uses Role::setPermissions()
     * @param string $name
     * @param string $description
     * @param bool $isPrivate
     * @param bool $isSystemDefined
     * @param bool $forceInheritance
     * @param \App\Library\ExactTarget\StructType\PermissionSets $permissionSets
     * @param \App\Library\ExactTarget\StructType\Permissions $permissions
     */
    public function __construct($name = null, $description = null, $isPrivate = null, $isSystemDefined = null, $forceInheritance = null, \App\Library\ExactTarget\StructType\PermissionSets $permissionSets = null, \App\Library\ExactTarget\StructType\Permissions $permissions = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsPrivate($isPrivate)
            ->setIsSystemDefined($isSystemDefined)
            ->setForceInheritance($forceInheritance)
            ->setPermissionSets($permissionSets)
            ->setPermissions($permissions);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\Role
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \App\Library\ExactTarget\StructType\Role
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get IsPrivate value
     * @return bool|null
     */
    public function getIsPrivate()
    {
        return $this->IsPrivate;
    }
    /**
     * Set IsPrivate value
     * @param bool $isPrivate
     * @return \App\Library\ExactTarget\StructType\Role
     */
    public function setIsPrivate($isPrivate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrivate) && !is_bool($isPrivate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPrivate)), __LINE__);
        }
        $this->IsPrivate = $isPrivate;
        return $this;
    }
    /**
     * Get IsSystemDefined value
     * @return bool|null
     */
    public function getIsSystemDefined()
    {
        return $this->IsSystemDefined;
    }
    /**
     * Set IsSystemDefined value
     * @param bool $isSystemDefined
     * @return \App\Library\ExactTarget\StructType\Role
     */
    public function setIsSystemDefined($isSystemDefined = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystemDefined) && !is_bool($isSystemDefined)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSystemDefined)), __LINE__);
        }
        $this->IsSystemDefined = $isSystemDefined;
        return $this;
    }
    /**
     * Get ForceInheritance value
     * @return bool|null
     */
    public function getForceInheritance()
    {
        return $this->ForceInheritance;
    }
    /**
     * Set ForceInheritance value
     * @param bool $forceInheritance
     * @return \App\Library\ExactTarget\StructType\Role
     */
    public function setForceInheritance($forceInheritance = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceInheritance) && !is_bool($forceInheritance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forceInheritance)), __LINE__);
        }
        $this->ForceInheritance = $forceInheritance;
        return $this;
    }
    /**
     * Get PermissionSets value
     * @return \App\Library\ExactTarget\StructType\PermissionSets|null
     */
    public function getPermissionSets()
    {
        return $this->PermissionSets;
    }
    /**
     * Set PermissionSets value
     * @param \App\Library\ExactTarget\StructType\PermissionSets $permissionSets
     * @return \App\Library\ExactTarget\StructType\Role
     */
    public function setPermissionSets(\App\Library\ExactTarget\StructType\PermissionSets $permissionSets = null)
    {
        $this->PermissionSets = $permissionSets;
        return $this;
    }
    /**
     * Get Permissions value
     * @return \App\Library\ExactTarget\StructType\Permissions|null
     */
    public function getPermissions()
    {
        return $this->Permissions;
    }
    /**
     * Set Permissions value
     * @param \App\Library\ExactTarget\StructType\Permissions $permissions
     * @return \App\Library\ExactTarget\StructType\Role
     */
    public function setPermissions(\App\Library\ExactTarget\StructType\Permissions $permissions = null)
    {
        $this->Permissions = $permissions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Role
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
