<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Retrieves StructType
 * @subpackage Structs
 */
class Retrieves extends AbstractStructBase
{
    /**
     * The Request
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Request[]
     */
    public $Request;
    /**
     * Constructor method for Retrieves
     * @uses Retrieves::setRequest()
     * @param \App\Library\ExactTarget\StructType\Request[] $request
     */
    public function __construct(array $request = array())
    {
        $this
            ->setRequest($request);
    }
    /**
     * Get Request value
     * @return \App\Library\ExactTarget\StructType\Request[]|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Request[] $request
     * @return \App\Library\ExactTarget\StructType\Retrieves
     */
    public function setRequest(array $request = array())
    {
        foreach ($request as $retrievesRequestItem) {
            // validation for constraint: itemType
            if (!$retrievesRequestItem instanceof \App\Library\ExactTarget\StructType\Request) {
                throw new \InvalidArgumentException(sprintf('The Request property can only contain items of \App\Library\ExactTarget\StructType\Request, "%s" given', is_object($retrievesRequestItem) ? get_class($retrievesRequestItem) : gettype($retrievesRequestItem)), __LINE__);
            }
        }
        $this->Request = $request;
        return $this;
    }
    /**
     * Add item to Request value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\Request $item
     * @return \App\Library\ExactTarget\StructType\Retrieves
     */
    public function addToRequest(\App\Library\ExactTarget\StructType\Request $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\Request) {
            throw new \InvalidArgumentException(sprintf('The Request property can only contain items of \App\Library\ExactTarget\StructType\Request, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Request[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Retrieves
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
