<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveSingleRequest StructType
 * @subpackage Structs
 */
class RetrieveSingleRequest extends Request
{
    /**
     * The RequestedObject
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\APIObject
     */
    public $RequestedObject;
    /**
     * The RetrieveOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Options
     */
    public $RetrieveOption;
    /**
     * Constructor method for RetrieveSingleRequest
     * @uses RetrieveSingleRequest::setRequestedObject()
     * @uses RetrieveSingleRequest::setRetrieveOption()
     * @param \App\Library\ExactTarget\StructType\APIObject $requestedObject
     * @param \App\Library\ExactTarget\StructType\Options $retrieveOption
     */
    public function __construct(\App\Library\ExactTarget\StructType\APIObject $requestedObject = null, \App\Library\ExactTarget\StructType\Options $retrieveOption = null)
    {
        $this
            ->setRequestedObject($requestedObject)
            ->setRetrieveOption($retrieveOption);
    }
    /**
     * Get RequestedObject value
     * @return \App\Library\ExactTarget\StructType\APIObject
     */
    public function getRequestedObject()
    {
        return $this->RequestedObject;
    }
    /**
     * Set RequestedObject value
     * @param \App\Library\ExactTarget\StructType\APIObject $requestedObject
     * @return \App\Library\ExactTarget\StructType\RetrieveSingleRequest
     */
    public function setRequestedObject(\App\Library\ExactTarget\StructType\APIObject $requestedObject = null)
    {
        $this->RequestedObject = $requestedObject;
        return $this;
    }
    /**
     * Get RetrieveOption value
     * @return \App\Library\ExactTarget\StructType\Options|null
     */
    public function getRetrieveOption()
    {
        return $this->RetrieveOption;
    }
    /**
     * Set RetrieveOption value
     * @param \App\Library\ExactTarget\StructType\Options $retrieveOption
     * @return \App\Library\ExactTarget\StructType\RetrieveSingleRequest
     */
    public function setRetrieveOption(\App\Library\ExactTarget\StructType\Options $retrieveOption = null)
    {
        $this->RetrieveOption = $retrieveOption;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\RetrieveSingleRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
