<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveResponseMsg StructType
 * @subpackage Structs
 */
class RetrieveResponseMsg extends AbstractStructBase
{
    /**
     * The OverallStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OverallStatus;
    /**
     * The RequestID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RequestID;
    /**
     * The Results
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIObject[]
     */
    public $Results;
    /**
     * Constructor method for RetrieveResponseMsg
     * @uses RetrieveResponseMsg::setOverallStatus()
     * @uses RetrieveResponseMsg::setRequestID()
     * @uses RetrieveResponseMsg::setResults()
     * @param string $overallStatus
     * @param string $requestID
     * @param \App\Library\ExactTarget\StructType\APIObject[] $results
     */
    public function __construct($overallStatus = null, $requestID = null, array $results = array())
    {
        $this
            ->setOverallStatus($overallStatus)
            ->setRequestID($requestID)
            ->setResults($results);
    }
    /**
     * Get OverallStatus value
     * @return string
     */
    public function getOverallStatus()
    {
        return $this->OverallStatus;
    }
    /**
     * Set OverallStatus value
     * @param string $overallStatus
     * @return \App\Library\ExactTarget\StructType\RetrieveResponseMsg
     */
    public function setOverallStatus($overallStatus = null)
    {
        // validation for constraint: string
        if (!is_null($overallStatus) && !is_string($overallStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overallStatus)), __LINE__);
        }
        $this->OverallStatus = $overallStatus;
        return $this;
    }
    /**
     * Get RequestID value
     * @return string|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param string $requestID
     * @return \App\Library\ExactTarget\StructType\RetrieveResponseMsg
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Get Results value
     * @return \App\Library\ExactTarget\StructType\APIObject[]|null
     */
    public function getResults()
    {
        return $this->Results;
    }
    /**
     * Set Results value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIObject[] $results
     * @return \App\Library\ExactTarget\StructType\RetrieveResponseMsg
     */
    public function setResults(array $results = array())
    {
        foreach ($results as $retrieveResponseMsgResultsItem) {
            // validation for constraint: itemType
            if (!$retrieveResponseMsgResultsItem instanceof \App\Library\ExactTarget\StructType\APIObject) {
                throw new \InvalidArgumentException(sprintf('The Results property can only contain items of \App\Library\ExactTarget\StructType\APIObject, "%s" given', is_object($retrieveResponseMsgResultsItem) ? get_class($retrieveResponseMsgResultsItem) : gettype($retrieveResponseMsgResultsItem)), __LINE__);
            }
        }
        $this->Results = $results;
        return $this;
    }
    /**
     * Add item to Results value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIObject $item
     * @return \App\Library\ExactTarget\StructType\RetrieveResponseMsg
     */
    public function addToResults(\App\Library\ExactTarget\StructType\APIObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIObject) {
            throw new \InvalidArgumentException(sprintf('The Results property can only contain items of \App\Library\ExactTarget\StructType\APIObject, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Results[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\RetrieveResponseMsg
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
