<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveOptions StructType
 * @subpackage Structs
 */
class RetrieveOptions extends Options
{
    /**
     * The BatchSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BatchSize;
    /**
     * The IncludeObjects
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeObjects;
    /**
     * The OnlyIncludeBase
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OnlyIncludeBase;
    /**
     * Constructor method for RetrieveOptions
     * @uses RetrieveOptions::setBatchSize()
     * @uses RetrieveOptions::setIncludeObjects()
     * @uses RetrieveOptions::setOnlyIncludeBase()
     * @param int $batchSize
     * @param bool $includeObjects
     * @param bool $onlyIncludeBase
     */
    public function __construct($batchSize = null, $includeObjects = null, $onlyIncludeBase = null)
    {
        $this
            ->setBatchSize($batchSize)
            ->setIncludeObjects($includeObjects)
            ->setOnlyIncludeBase($onlyIncludeBase);
    }
    /**
     * Get BatchSize value
     * @return int|null
     */
    public function getBatchSize()
    {
        return $this->BatchSize;
    }
    /**
     * Set BatchSize value
     * @param int $batchSize
     * @return \App\Library\ExactTarget\StructType\RetrieveOptions
     */
    public function setBatchSize($batchSize = null)
    {
        // validation for constraint: int
        if (!is_null($batchSize) && !is_numeric($batchSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($batchSize)), __LINE__);
        }
        $this->BatchSize = $batchSize;
        return $this;
    }
    /**
     * Get IncludeObjects value
     * @return bool|null
     */
    public function getIncludeObjects()
    {
        return $this->IncludeObjects;
    }
    /**
     * Set IncludeObjects value
     * @param bool $includeObjects
     * @return \App\Library\ExactTarget\StructType\RetrieveOptions
     */
    public function setIncludeObjects($includeObjects = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeObjects) && !is_bool($includeObjects)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeObjects)), __LINE__);
        }
        $this->IncludeObjects = $includeObjects;
        return $this;
    }
    /**
     * Get OnlyIncludeBase value
     * @return bool|null
     */
    public function getOnlyIncludeBase()
    {
        return $this->OnlyIncludeBase;
    }
    /**
     * Set OnlyIncludeBase value
     * @param bool $onlyIncludeBase
     * @return \App\Library\ExactTarget\StructType\RetrieveOptions
     */
    public function setOnlyIncludeBase($onlyIncludeBase = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyIncludeBase) && !is_bool($onlyIncludeBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($onlyIncludeBase)), __LINE__);
        }
        $this->OnlyIncludeBase = $onlyIncludeBase;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\RetrieveOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
