<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Results StructType
 * @subpackage Structs
 */
class Results extends AbstractStructBase
{
    /**
     * The Result
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIProperty[]
     */
    public $Result;
    /**
     * Constructor method for Results
     * @uses Results::setResult()
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $result
     */
    public function __construct(array $result = array())
    {
        $this
            ->setResult($result);
    }
    /**
     * Get Result value
     * @return \App\Library\ExactTarget\StructType\APIProperty[]|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $result
     * @return \App\Library\ExactTarget\StructType\Results
     */
    public function setResult(array $result = array())
    {
        foreach ($result as $resultsResultItem) {
            // validation for constraint: itemType
            if (!$resultsResultItem instanceof \App\Library\ExactTarget\StructType\APIProperty) {
                throw new \InvalidArgumentException(sprintf('The Result property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($resultsResultItem) ? get_class($resultsResultItem) : gettype($resultsResultItem)), __LINE__);
            }
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Add item to Result value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty $item
     * @return \App\Library\ExactTarget\StructType\Results
     */
    public function addToResult(\App\Library\ExactTarget\StructType\APIProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIProperty) {
            throw new \InvalidArgumentException(sprintf('The Result property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Result[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Results
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
