<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Result StructType
 * @subpackage Structs
 */
class Result extends AbstractStructBase
{
    /**
     * The StatusCode
     * @var string
     */
    public $StatusCode;
    /**
     * The StatusMessage
     * @var string
     */
    public $StatusMessage;
    /**
     * The OrdinalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OrdinalID;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ErrorCode;
    /**
     * The RequestID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RequestID;
    /**
     * The ConversationID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ConversationID;
    /**
     * The OverallStatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OverallStatusCode;
    /**
     * The RequestType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RequestType;
    /**
     * The ResultType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ResultType;
    /**
     * The ResultDetailXML
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ResultDetailXML;
    /**
     * Constructor method for Result
     * @uses Result::setStatusCode()
     * @uses Result::setStatusMessage()
     * @uses Result::setOrdinalID()
     * @uses Result::setErrorCode()
     * @uses Result::setRequestID()
     * @uses Result::setConversationID()
     * @uses Result::setOverallStatusCode()
     * @uses Result::setRequestType()
     * @uses Result::setResultType()
     * @uses Result::setResultDetailXML()
     * @param string $statusCode
     * @param string $statusMessage
     * @param int $ordinalID
     * @param int $errorCode
     * @param string $requestID
     * @param string $conversationID
     * @param string $overallStatusCode
     * @param string $requestType
     * @param string $resultType
     * @param string $resultDetailXML
     */
    public function __construct($statusCode = null, $statusMessage = null, $ordinalID = null, $errorCode = null, $requestID = null, $conversationID = null, $overallStatusCode = null, $requestType = null, $resultType = null, $resultDetailXML = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setStatusMessage($statusMessage)
            ->setOrdinalID($ordinalID)
            ->setErrorCode($errorCode)
            ->setRequestID($requestID)
            ->setConversationID($conversationID)
            ->setOverallStatusCode($overallStatusCode)
            ->setRequestType($requestType)
            ->setResultType($resultType)
            ->setResultDetailXML($resultDetailXML);
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \App\Library\ExactTarget\StructType\Result
     */
    public function setStatusCode($statusCode = null)
    {
        // validation for constraint: string
        if (!is_null($statusCode) && !is_string($statusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusCode)), __LINE__);
        }
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get StatusMessage value
     * @return string|null
     */
    public function getStatusMessage()
    {
        return $this->StatusMessage;
    }
    /**
     * Set StatusMessage value
     * @param string $statusMessage
     * @return \App\Library\ExactTarget\StructType\Result
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusMessage)), __LINE__);
        }
        $this->StatusMessage = $statusMessage;
        return $this;
    }
    /**
     * Get OrdinalID value
     * @return int|null
     */
    public function getOrdinalID()
    {
        return $this->OrdinalID;
    }
    /**
     * Set OrdinalID value
     * @param int $ordinalID
     * @return \App\Library\ExactTarget\StructType\Result
     */
    public function setOrdinalID($ordinalID = null)
    {
        // validation for constraint: int
        if (!is_null($ordinalID) && !is_numeric($ordinalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ordinalID)), __LINE__);
        }
        $this->OrdinalID = $ordinalID;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \App\Library\ExactTarget\StructType\Result
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get RequestID value
     * @return string|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param string $requestID
     * @return \App\Library\ExactTarget\StructType\Result
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Get ConversationID value
     * @return string|null
     */
    public function getConversationID()
    {
        return $this->ConversationID;
    }
    /**
     * Set ConversationID value
     * @param string $conversationID
     * @return \App\Library\ExactTarget\StructType\Result
     */
    public function setConversationID($conversationID = null)
    {
        // validation for constraint: string
        if (!is_null($conversationID) && !is_string($conversationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conversationID)), __LINE__);
        }
        $this->ConversationID = $conversationID;
        return $this;
    }
    /**
     * Get OverallStatusCode value
     * @return string|null
     */
    public function getOverallStatusCode()
    {
        return $this->OverallStatusCode;
    }
    /**
     * Set OverallStatusCode value
     * @param string $overallStatusCode
     * @return \App\Library\ExactTarget\StructType\Result
     */
    public function setOverallStatusCode($overallStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($overallStatusCode) && !is_string($overallStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overallStatusCode)), __LINE__);
        }
        $this->OverallStatusCode = $overallStatusCode;
        return $this;
    }
    /**
     * Get RequestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->RequestType;
    }
    /**
     * Set RequestType value
     * @uses \App\Library\ExactTarget\EnumType\RequestType::valueIsValid()
     * @uses \App\Library\ExactTarget\EnumType\RequestType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestType
     * @return \App\Library\ExactTarget\StructType\Result
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: enumeration
        if (!\App\Library\ExactTarget\EnumType\RequestType::valueIsValid($requestType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $requestType, implode(', ', \App\Library\ExactTarget\EnumType\RequestType::getValidValues())), __LINE__);
        }
        $this->RequestType = $requestType;
        return $this;
    }
    /**
     * Get ResultType value
     * @return string|null
     */
    public function getResultType()
    {
        return $this->ResultType;
    }
    /**
     * Set ResultType value
     * @param string $resultType
     * @return \App\Library\ExactTarget\StructType\Result
     */
    public function setResultType($resultType = null)
    {
        // validation for constraint: string
        if (!is_null($resultType) && !is_string($resultType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultType)), __LINE__);
        }
        $this->ResultType = $resultType;
        return $this;
    }
    /**
     * Get ResultDetailXML value
     * @return string|null
     */
    public function getResultDetailXML()
    {
        return $this->ResultDetailXML;
    }
    /**
     * Set ResultDetailXML value
     * @param string $resultDetailXML
     * @return \App\Library\ExactTarget\StructType\Result
     */
    public function setResultDetailXML($resultDetailXML = null)
    {
        // validation for constraint: string
        if (!is_null($resultDetailXML) && !is_string($resultDetailXML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultDetailXML)), __LINE__);
        }
        $this->ResultDetailXML = $resultDetailXML;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Result
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
