<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResourceSpecification StructType
 * @subpackage Structs
 */
class ResourceSpecification extends APIObject
{
    /**
     * The URN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URN;
    /**
     * The Authentication
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Authentication
     */
    public $Authentication;
    /**
     * Constructor method for ResourceSpecification
     * @uses ResourceSpecification::setURN()
     * @uses ResourceSpecification::setAuthentication()
     * @param string $uRN
     * @param \App\Library\ExactTarget\StructType\Authentication $authentication
     */
    public function __construct($uRN = null, \App\Library\ExactTarget\StructType\Authentication $authentication = null)
    {
        $this
            ->setURN($uRN)
            ->setAuthentication($authentication);
    }
    /**
     * Get URN value
     * @return string|null
     */
    public function getURN()
    {
        return $this->URN;
    }
    /**
     * Set URN value
     * @param string $uRN
     * @return \App\Library\ExactTarget\StructType\ResourceSpecification
     */
    public function setURN($uRN = null)
    {
        // validation for constraint: string
        if (!is_null($uRN) && !is_string($uRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRN)), __LINE__);
        }
        $this->URN = $uRN;
        return $this;
    }
    /**
     * Get Authentication value
     * @return \App\Library\ExactTarget\StructType\Authentication|null
     */
    public function getAuthentication()
    {
        return $this->Authentication;
    }
    /**
     * Set Authentication value
     * @param \App\Library\ExactTarget\StructType\Authentication $authentication
     * @return \App\Library\ExactTarget\StructType\ResourceSpecification
     */
    public function setAuthentication(\App\Library\ExactTarget\StructType\Authentication $authentication = null)
    {
        $this->Authentication = $authentication;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\ResourceSpecification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
