<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for References StructType
 * Meta informations extracted from the WSDL
 * - documentation: Indicates the object types of the referenced objects. | Reserved for future use.
 * @subpackage Structs
 */
class References extends AbstractStructBase
{
    /**
     * The Reference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIObject[]
     */
    public $Reference;
    /**
     * Constructor method for References
     * @uses References::setReference()
     * @param \App\Library\ExactTarget\StructType\APIObject[] $reference
     */
    public function __construct(array $reference = array())
    {
        $this
            ->setReference($reference);
    }
    /**
     * Get Reference value
     * @return \App\Library\ExactTarget\StructType\APIObject[]|null
     */
    public function getReference()
    {
        return $this->Reference;
    }
    /**
     * Set Reference value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIObject[] $reference
     * @return \App\Library\ExactTarget\StructType\References
     */
    public function setReference(array $reference = array())
    {
        foreach ($reference as $referencesReferenceItem) {
            // validation for constraint: itemType
            if (!$referencesReferenceItem instanceof \App\Library\ExactTarget\StructType\APIObject) {
                throw new \InvalidArgumentException(sprintf('The Reference property can only contain items of \App\Library\ExactTarget\StructType\APIObject, "%s" given', is_object($referencesReferenceItem) ? get_class($referencesReferenceItem) : gettype($referencesReferenceItem)), __LINE__);
            }
        }
        $this->Reference = $reference;
        return $this;
    }
    /**
     * Add item to Reference value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIObject $item
     * @return \App\Library\ExactTarget\StructType\References
     */
    public function addToReference(\App\Library\ExactTarget\StructType\APIObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIObject) {
            throw new \InvalidArgumentException(sprintf('The Reference property can only contain items of \App\Library\ExactTarget\StructType\APIObject, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Reference[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\References
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
