<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryRequest StructType
 * @subpackage Structs
 */
class QueryRequest extends AbstractStructBase
{
    /**
     * The Query
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \App\Library\ExactTarget\StructType\Query
     */
    public $Query;
    /**
     * The ClientIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\ClientID[]
     */
    public $ClientIDs;
    /**
     * The RespondTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\AsyncResponse[]
     */
    public $RespondTo;
    /**
     * The PartnerProperties
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\APIProperty[]
     */
    public $PartnerProperties;
    /**
     * The ContinueRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContinueRequest;
    /**
     * The QueryAllAccounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $QueryAllAccounts;
    /**
     * The RetrieveAllSinceLastBatch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RetrieveAllSinceLastBatch;
    /**
     * Constructor method for QueryRequest
     * @uses QueryRequest::setQuery()
     * @uses QueryRequest::setClientIDs()
     * @uses QueryRequest::setRespondTo()
     * @uses QueryRequest::setPartnerProperties()
     * @uses QueryRequest::setContinueRequest()
     * @uses QueryRequest::setQueryAllAccounts()
     * @uses QueryRequest::setRetrieveAllSinceLastBatch()
     * @param \App\Library\ExactTarget\StructType\Query $query
     * @param \App\Library\ExactTarget\StructType\ClientID[] $clientIDs
     * @param \App\Library\ExactTarget\StructType\AsyncResponse[] $respondTo
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $partnerProperties
     * @param string $continueRequest
     * @param bool $queryAllAccounts
     * @param bool $retrieveAllSinceLastBatch
     */
    public function __construct(\App\Library\ExactTarget\StructType\Query $query = null, array $clientIDs = array(), array $respondTo = array(), array $partnerProperties = array(), $continueRequest = null, $queryAllAccounts = null, $retrieveAllSinceLastBatch = null)
    {
        $this
            ->setQuery($query)
            ->setClientIDs($clientIDs)
            ->setRespondTo($respondTo)
            ->setPartnerProperties($partnerProperties)
            ->setContinueRequest($continueRequest)
            ->setQueryAllAccounts($queryAllAccounts)
            ->setRetrieveAllSinceLastBatch($retrieveAllSinceLastBatch);
    }
    /**
     * Get Query value
     * @return \App\Library\ExactTarget\StructType\Query
     */
    public function getQuery()
    {
        return $this->Query;
    }
    /**
     * Set Query value
     * @param \App\Library\ExactTarget\StructType\Query $query
     * @return \App\Library\ExactTarget\StructType\QueryRequest
     */
    public function setQuery(\App\Library\ExactTarget\StructType\Query $query = null)
    {
        $this->Query = $query;
        return $this;
    }
    /**
     * Get ClientIDs value
     * @return \App\Library\ExactTarget\StructType\ClientID[]|null
     */
    public function getClientIDs()
    {
        return $this->ClientIDs;
    }
    /**
     * Set ClientIDs value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ClientID[] $clientIDs
     * @return \App\Library\ExactTarget\StructType\QueryRequest
     */
    public function setClientIDs(array $clientIDs = array())
    {
        foreach ($clientIDs as $queryRequestClientIDsItem) {
            // validation for constraint: itemType
            if (!$queryRequestClientIDsItem instanceof \App\Library\ExactTarget\StructType\ClientID) {
                throw new \InvalidArgumentException(sprintf('The ClientIDs property can only contain items of \App\Library\ExactTarget\StructType\ClientID, "%s" given', is_object($queryRequestClientIDsItem) ? get_class($queryRequestClientIDsItem) : gettype($queryRequestClientIDsItem)), __LINE__);
            }
        }
        $this->ClientIDs = $clientIDs;
        return $this;
    }
    /**
     * Add item to ClientIDs value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\ClientID $item
     * @return \App\Library\ExactTarget\StructType\QueryRequest
     */
    public function addToClientIDs(\App\Library\ExactTarget\StructType\ClientID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\ClientID) {
            throw new \InvalidArgumentException(sprintf('The ClientIDs property can only contain items of \App\Library\ExactTarget\StructType\ClientID, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ClientIDs[] = $item;
        return $this;
    }
    /**
     * Get RespondTo value
     * @return \App\Library\ExactTarget\StructType\AsyncResponse[]|null
     */
    public function getRespondTo()
    {
        return $this->RespondTo;
    }
    /**
     * Set RespondTo value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AsyncResponse[] $respondTo
     * @return \App\Library\ExactTarget\StructType\QueryRequest
     */
    public function setRespondTo(array $respondTo = array())
    {
        foreach ($respondTo as $queryRequestRespondToItem) {
            // validation for constraint: itemType
            if (!$queryRequestRespondToItem instanceof \App\Library\ExactTarget\StructType\AsyncResponse) {
                throw new \InvalidArgumentException(sprintf('The RespondTo property can only contain items of \App\Library\ExactTarget\StructType\AsyncResponse, "%s" given', is_object($queryRequestRespondToItem) ? get_class($queryRequestRespondToItem) : gettype($queryRequestRespondToItem)), __LINE__);
            }
        }
        $this->RespondTo = $respondTo;
        return $this;
    }
    /**
     * Add item to RespondTo value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\AsyncResponse $item
     * @return \App\Library\ExactTarget\StructType\QueryRequest
     */
    public function addToRespondTo(\App\Library\ExactTarget\StructType\AsyncResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\AsyncResponse) {
            throw new \InvalidArgumentException(sprintf('The RespondTo property can only contain items of \App\Library\ExactTarget\StructType\AsyncResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RespondTo[] = $item;
        return $this;
    }
    /**
     * Get PartnerProperties value
     * @return \App\Library\ExactTarget\StructType\APIProperty[]|null
     */
    public function getPartnerProperties()
    {
        return $this->PartnerProperties;
    }
    /**
     * Set PartnerProperties value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty[] $partnerProperties
     * @return \App\Library\ExactTarget\StructType\QueryRequest
     */
    public function setPartnerProperties(array $partnerProperties = array())
    {
        foreach ($partnerProperties as $queryRequestPartnerPropertiesItem) {
            // validation for constraint: itemType
            if (!$queryRequestPartnerPropertiesItem instanceof \App\Library\ExactTarget\StructType\APIProperty) {
                throw new \InvalidArgumentException(sprintf('The PartnerProperties property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($queryRequestPartnerPropertiesItem) ? get_class($queryRequestPartnerPropertiesItem) : gettype($queryRequestPartnerPropertiesItem)), __LINE__);
            }
        }
        $this->PartnerProperties = $partnerProperties;
        return $this;
    }
    /**
     * Add item to PartnerProperties value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\APIProperty $item
     * @return \App\Library\ExactTarget\StructType\QueryRequest
     */
    public function addToPartnerProperties(\App\Library\ExactTarget\StructType\APIProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\APIProperty) {
            throw new \InvalidArgumentException(sprintf('The PartnerProperties property can only contain items of \App\Library\ExactTarget\StructType\APIProperty, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PartnerProperties[] = $item;
        return $this;
    }
    /**
     * Get ContinueRequest value
     * @return string|null
     */
    public function getContinueRequest()
    {
        return $this->ContinueRequest;
    }
    /**
     * Set ContinueRequest value
     * @param string $continueRequest
     * @return \App\Library\ExactTarget\StructType\QueryRequest
     */
    public function setContinueRequest($continueRequest = null)
    {
        // validation for constraint: string
        if (!is_null($continueRequest) && !is_string($continueRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($continueRequest)), __LINE__);
        }
        $this->ContinueRequest = $continueRequest;
        return $this;
    }
    /**
     * Get QueryAllAccounts value
     * @return bool|null
     */
    public function getQueryAllAccounts()
    {
        return $this->QueryAllAccounts;
    }
    /**
     * Set QueryAllAccounts value
     * @param bool $queryAllAccounts
     * @return \App\Library\ExactTarget\StructType\QueryRequest
     */
    public function setQueryAllAccounts($queryAllAccounts = null)
    {
        // validation for constraint: boolean
        if (!is_null($queryAllAccounts) && !is_bool($queryAllAccounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($queryAllAccounts)), __LINE__);
        }
        $this->QueryAllAccounts = $queryAllAccounts;
        return $this;
    }
    /**
     * Get RetrieveAllSinceLastBatch value
     * @return bool|null
     */
    public function getRetrieveAllSinceLastBatch()
    {
        return $this->RetrieveAllSinceLastBatch;
    }
    /**
     * Set RetrieveAllSinceLastBatch value
     * @param bool $retrieveAllSinceLastBatch
     * @return \App\Library\ExactTarget\StructType\QueryRequest
     */
    public function setRetrieveAllSinceLastBatch($retrieveAllSinceLastBatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($retrieveAllSinceLastBatch) && !is_bool($retrieveAllSinceLastBatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($retrieveAllSinceLastBatch)), __LINE__);
        }
        $this->RetrieveAllSinceLastBatch = $retrieveAllSinceLastBatch;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\QueryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
