<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryObject StructType
 * @subpackage Structs
 */
class QueryObject extends AbstractStructBase
{
    /**
     * The ObjectType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ObjectType;
    /**
     * The Properties
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $Properties;
    /**
     * The Objects
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\QueryObject[]
     */
    public $Objects;
    /**
     * Constructor method for QueryObject
     * @uses QueryObject::setObjectType()
     * @uses QueryObject::setProperties()
     * @uses QueryObject::setObjects()
     * @param string $objectType
     * @param string[] $properties
     * @param \App\Library\ExactTarget\StructType\QueryObject[] $objects
     */
    public function __construct($objectType = null, array $properties = array(), array $objects = array())
    {
        $this
            ->setObjectType($objectType)
            ->setProperties($properties)
            ->setObjects($objects);
    }
    /**
     * Get ObjectType value
     * @return string
     */
    public function getObjectType()
    {
        return $this->ObjectType;
    }
    /**
     * Set ObjectType value
     * @param string $objectType
     * @return \App\Library\ExactTarget\StructType\QueryObject
     */
    public function setObjectType($objectType = null)
    {
        // validation for constraint: string
        if (!is_null($objectType) && !is_string($objectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectType)), __LINE__);
        }
        $this->ObjectType = $objectType;
        return $this;
    }
    /**
     * Get Properties value
     * @return string[]
     */
    public function getProperties()
    {
        return $this->Properties;
    }
    /**
     * Set Properties value
     * @throws \InvalidArgumentException
     * @param string[] $properties
     * @return \App\Library\ExactTarget\StructType\QueryObject
     */
    public function setProperties(array $properties = array())
    {
        foreach ($properties as $queryObjectPropertiesItem) {
            // validation for constraint: itemType
            if (!is_string($queryObjectPropertiesItem)) {
                throw new \InvalidArgumentException(sprintf('The Properties property can only contain items of string, "%s" given', is_object($queryObjectPropertiesItem) ? get_class($queryObjectPropertiesItem) : gettype($queryObjectPropertiesItem)), __LINE__);
            }
        }
        $this->Properties = $properties;
        return $this;
    }
    /**
     * Add item to Properties value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\Library\ExactTarget\StructType\QueryObject
     */
    public function addToProperties($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Properties property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Properties[] = $item;
        return $this;
    }
    /**
     * Get Objects value
     * @return \App\Library\ExactTarget\StructType\QueryObject[]|null
     */
    public function getObjects()
    {
        return $this->Objects;
    }
    /**
     * Set Objects value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\QueryObject[] $objects
     * @return \App\Library\ExactTarget\StructType\QueryObject
     */
    public function setObjects(array $objects = array())
    {
        foreach ($objects as $queryObjectObjectsItem) {
            // validation for constraint: itemType
            if (!$queryObjectObjectsItem instanceof \App\Library\ExactTarget\StructType\QueryObject) {
                throw new \InvalidArgumentException(sprintf('The Objects property can only contain items of \App\Library\ExactTarget\StructType\QueryObject, "%s" given', is_object($queryObjectObjectsItem) ? get_class($queryObjectObjectsItem) : gettype($queryObjectObjectsItem)), __LINE__);
            }
        }
        $this->Objects = $objects;
        return $this;
    }
    /**
     * Add item to Objects value
     * @throws \InvalidArgumentException
     * @param \App\Library\ExactTarget\StructType\QueryObject $item
     * @return \App\Library\ExactTarget\StructType\QueryObject
     */
    public function addToObjects(\App\Library\ExactTarget\StructType\QueryObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\Library\ExactTarget\StructType\QueryObject) {
            throw new \InvalidArgumentException(sprintf('The Objects property can only contain items of \App\Library\ExactTarget\StructType\QueryObject, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Objects[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\QueryObject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
