<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PublicationSubscriber StructType
 * @subpackage Structs
 */
class PublicationSubscriber extends APIObject
{
    /**
     * The Publication
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Publication
     */
    public $Publication;
    /**
     * The Subscriber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Subscriber
     */
    public $Subscriber;
    /**
     * Constructor method for PublicationSubscriber
     * @uses PublicationSubscriber::setPublication()
     * @uses PublicationSubscriber::setSubscriber()
     * @param \App\Library\ExactTarget\StructType\Publication $publication
     * @param \App\Library\ExactTarget\StructType\Subscriber $subscriber
     */
    public function __construct(\App\Library\ExactTarget\StructType\Publication $publication = null, \App\Library\ExactTarget\StructType\Subscriber $subscriber = null)
    {
        $this
            ->setPublication($publication)
            ->setSubscriber($subscriber);
    }
    /**
     * Get Publication value
     * @return \App\Library\ExactTarget\StructType\Publication|null
     */
    public function getPublication()
    {
        return $this->Publication;
    }
    /**
     * Set Publication value
     * @param \App\Library\ExactTarget\StructType\Publication $publication
     * @return \App\Library\ExactTarget\StructType\PublicationSubscriber
     */
    public function setPublication(\App\Library\ExactTarget\StructType\Publication $publication = null)
    {
        $this->Publication = $publication;
        return $this;
    }
    /**
     * Get Subscriber value
     * @return \App\Library\ExactTarget\StructType\Subscriber|null
     */
    public function getSubscriber()
    {
        return $this->Subscriber;
    }
    /**
     * Set Subscriber value
     * @param \App\Library\ExactTarget\StructType\Subscriber $subscriber
     * @return \App\Library\ExactTarget\StructType\PublicationSubscriber
     */
    public function setSubscriber(\App\Library\ExactTarget\StructType\Subscriber $subscriber = null)
    {
        $this->Subscriber = $subscriber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\PublicationSubscriber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
