<?php

namespace App\Library\ExactTarget\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Publication StructType
 * @subpackage Structs
 */
class Publication extends APIObject
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The SendClassification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\SendClassification
     */
    public $SendClassification;
    /**
     * The Subscribers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \App\Library\ExactTarget\StructType\Subscribers
     */
    public $Subscribers;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Category;
    /**
     * Constructor method for Publication
     * @uses Publication::setName()
     * @uses Publication::setIsActive()
     * @uses Publication::setSendClassification()
     * @uses Publication::setSubscribers()
     * @uses Publication::setCategory()
     * @param string $name
     * @param bool $isActive
     * @param \App\Library\ExactTarget\StructType\SendClassification $sendClassification
     * @param \App\Library\ExactTarget\StructType\Subscribers $subscribers
     * @param int $category
     */
    public function __construct($name = null, $isActive = null, \App\Library\ExactTarget\StructType\SendClassification $sendClassification = null, \App\Library\ExactTarget\StructType\Subscribers $subscribers = null, $category = null)
    {
        $this
            ->setName($name)
            ->setIsActive($isActive)
            ->setSendClassification($sendClassification)
            ->setSubscribers($subscribers)
            ->setCategory($category);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \App\Library\ExactTarget\StructType\Publication
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \App\Library\ExactTarget\StructType\Publication
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get SendClassification value
     * @return \App\Library\ExactTarget\StructType\SendClassification|null
     */
    public function getSendClassification()
    {
        return $this->SendClassification;
    }
    /**
     * Set SendClassification value
     * @param \App\Library\ExactTarget\StructType\SendClassification $sendClassification
     * @return \App\Library\ExactTarget\StructType\Publication
     */
    public function setSendClassification(\App\Library\ExactTarget\StructType\SendClassification $sendClassification = null)
    {
        $this->SendClassification = $sendClassification;
        return $this;
    }
    /**
     * Get Subscribers value
     * @return \App\Library\ExactTarget\StructType\Subscribers|null
     */
    public function getSubscribers()
    {
        return $this->Subscribers;
    }
    /**
     * Set Subscribers value
     * @param \App\Library\ExactTarget\StructType\Subscribers $subscribers
     * @return \App\Library\ExactTarget\StructType\Publication
     */
    public function setSubscribers(\App\Library\ExactTarget\StructType\Subscribers $subscribers = null)
    {
        $this->Subscribers = $subscribers;
        return $this;
    }
    /**
     * Get Category value
     * @return int|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param int $category
     * @return \App\Library\ExactTarget\StructType\Publication
     */
    public function setCategory($category = null)
    {
        // validation for constraint: int
        if (!is_null($category) && !is_numeric($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\Library\ExactTarget\StructType\Publication
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
